/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.repository;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.model.page.PageResponse;
import cn.zhangfusheng.elasticsearch.repository.DefaultRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.search.SearchHit;
import org.springframework.util.CollectionUtils;

public interface DefaultElasticSearchQueryRepository<T>
extends DefaultRepository<T> {
    @Override
    default public Optional<T> findById(String primaryId) {
        return this.findById(primaryId, null);
    }

    @Override
    default public Optional<T> findById(String primaryId, String routing) {
        String indexName = this.entityRepositoryDetail().getIndexName();
        GetResponse getResponse = this.elasticSearchRestTemplate().get(indexName, routing, primaryId, new ArrayList<String>(0), new ArrayList<String>(0));
        Object t = this.entityRepositoryDetail().parseToEntity(getResponse.getSource());
        return Optional.ofNullable(t);
    }

    @Override
    default public <Q, R> Optional<R> findOne(Q q) {
        ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail = this.entityRepositoryDetail();
        String routing = elasticSearchEntityRepositoryDetail.routing(q);
        List<SearchHit> searchHits = this.elasticSearchRestTemplate().search(new Object[]{q}, routing, elasticSearchEntityRepositoryDetail);
        if (CollectionUtils.isEmpty(searchHits)) {
            return Optional.empty();
        }
        if (searchHits.size() != 1) {
            throw new GlobalSystemException("\u6839\u636e\u67e5\u8be2\u6761\u4ef6\u5f97\u5230{}\u6761\u6570\u636e", searchHits.size());
        }
        List rs = elasticSearchEntityRepositoryDetail.parseToEntity(searchHits, q.getClass());
        return Optional.ofNullable(rs.get(0));
    }

    @Override
    default public <Q, R> List<R> findAll(Q q) {
        ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail = this.entityRepositoryDetail();
        String routing = elasticSearchEntityRepositoryDetail.routing(q);
        List<SearchHit> searchHits = this.elasticSearchRestTemplate().search(new Object[]{q}, routing, elasticSearchEntityRepositoryDetail);
        return elasticSearchEntityRepositoryDetail.parseToEntity(searchHits, q.getClass());
    }

    @Override
    default public <Q, R> PageResponse<R> findForPage(Q q, PageRequest pageRequest) {
        ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail = this.entityRepositoryDetail();
        String routing = elasticSearchEntityRepositoryDetail.routing(q);
        PageResponse<SearchHit> pageResponse = this.elasticSearchRestTemplate().searchWithPage(new Object[]{q}, routing, elasticSearchEntityRepositoryDetail, pageRequest);
        List rs = elasticSearchEntityRepositoryDetail.parseToEntity(pageResponse.getData(), q.getClass());
        return new PageResponse(pageResponse.getSearchAfter(), pageResponse.getTotal(), pageResponse.getRelation(), rs);
    }
}

