/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.page;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;

public class PageResponse<T> {
    private Object[] searchAfter;
    private long total;
    private int skipTotal;
    private TotalHits.Relation relation;
    private List<T> data;

    public PageResponse(Object[] searchAfter, long total, TotalHits.Relation relation, List<T> data) {
        this.searchAfter = searchAfter;
        this.total = total;
        this.relation = relation;
        this.data = data;
    }

    public PageResponse(Object[] searchAfter, long total, List<T> data) {
        this.searchAfter = searchAfter;
        this.total = total;
        this.data = data;
    }

    public PageResponse(long total, List<T> data) {
        this.total = total;
        this.data = data;
    }

    public PageResponse<T> setTotal(TotalHits totalHits) {
        this.total = Objects.isNull(totalHits) ? 0L : totalHits.value;
        this.relation = totalHits.relation;
        return this;
    }

    public long getTotal() {
        return this.total + (long)this.skipTotal;
    }

    public Object[] getSearchAfter() {
        return this.searchAfter;
    }

    public int getSkipTotal() {
        return this.skipTotal;
    }

    public TotalHits.Relation getRelation() {
        return this.relation;
    }

    public List<T> getData() {
        return this.data;
    }

    public PageResponse<T> setSearchAfter(Object[] searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public PageResponse<T> setSkipTotal(int skipTotal) {
        this.skipTotal = skipTotal;
        return this;
    }

    public PageResponse<T> setRelation(TotalHits.Relation relation) {
        this.relation = relation;
        return this;
    }

    public PageResponse<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResponse)) {
            return false;
        }
        PageResponse other = (PageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getSkipTotal() != other.getSkipTotal()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSearchAfter(), other.getSearchAfter())) {
            return false;
        }
        TotalHits.Relation this$relation = this.getRelation();
        TotalHits.Relation other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getSkipTotal();
        result = result * 59 + Arrays.deepHashCode(this.getSearchAfter());
        TotalHits.Relation $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResponse(searchAfter=" + Arrays.deepToString(this.getSearchAfter()) + ", total=" + this.getTotal() + ", skipTotal=" + this.getSkipTotal() + ", relation=" + this.getRelation() + ", data=" + this.getData() + ")";
    }

    public PageResponse() {
    }
}

