/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.jexl;

import cn.zhangfusheng.elasticsearch.jexl.Jexl3Constant;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.impl.ForAnalysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.impl.IfElseAnalysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.impl.JoinAnalysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.impl.TxtAnalysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.impl.VariableAnalysis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public class Jexl3Analysis {
    private final String sourceLanguage;
    private int position;
    private int fromIndex;
    private final Matcher sourceLanguageMatcher;
    private final Matcher elseMatcher;
    private final List<Analysis> result = new ArrayList<Analysis>();

    public Jexl3Analysis(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        this.sourceLanguageMatcher = Jexl3Constant.PATTERN_KEYWORD.matcher(this.sourceLanguage);
        this.elseMatcher = Jexl3Constant.PATTERN_ELSE.matcher(sourceLanguage);
    }

    public List<Analysis> compile() {
        try {
            while (this.sourceLanguageMatcher.find(this.position)) {
                this.position = this.sourceLanguageMatcher.end();
                String expr = this.sourceLanguageMatcher.group(1);
                String group = this.sourceLanguageMatcher.group(2);
                String keyword = this.sourceLanguageMatcher.group(3);
                if (Objects.nonNull(expr)) {
                    if (this.sourceLanguageMatcher.start() > this.fromIndex) {
                        this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex, this.sourceLanguageMatcher.start())));
                    }
                    if (expr.charAt(0) == '$') {
                        this.result.add(new JoinAnalysis().setJoinExp(expr));
                    } else {
                        this.result.add(new VariableAnalysis(expr));
                    }
                } else if (Objects.nonNull(group)) {
                    this.result.addAll(new Jexl3Analysis(group).compile());
                } else if (Objects.isNull(keyword)) {
                    expr = this.parentheses();
                    if (Objects.nonNull(expr)) {
                        if (this.sourceLanguageMatcher.start() > this.fromIndex) {
                            this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex, this.sourceLanguageMatcher.start())));
                        }
                        this.result.add(new VariableAnalysis(expr));
                    }
                } else {
                    switch (keyword) {
                        case "if": {
                            this.ifElse();
                            break;
                        }
                        case "for": {
                            this.forLoop();
                            break;
                        }
                        case "#": 
                        case "!": {
                            this.join();
                        }
                    }
                }
                this.fromIndex = this.position;
            }
            if (this.fromIndex < this.sourceLanguage.length()) {
                this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.result;
    }

    private void join() {
        String joinStr = this.parentheses();
        if (Objects.nonNull(joinStr)) {
            if (this.sourceLanguageMatcher.start() > this.fromIndex) {
                this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex, this.sourceLanguageMatcher.start())));
            }
            this.result.add(new JoinAnalysis().setJoinExp(joinStr));
        }
    }

    private void forLoop() {
        String forCondition = this.parentheses();
        if (Objects.nonNull(forCondition)) {
            if (this.sourceLanguageMatcher.start() > this.fromIndex) {
                this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex, this.sourceLanguageMatcher.start())));
            }
            ForAnalysis forAnalysis = new ForAnalysis();
            Matcher matcherIn = Jexl3Constant.PATTERN_IN.matcher(forCondition);
            if (matcherIn.matches()) {
                forAnalysis.setVariable(matcherIn.group(1));
                forCondition = matcherIn.group(2);
            }
            forAnalysis.setForCondition(forCondition);
            String forExecute = this.braces();
            if (Objects.nonNull(forExecute)) {
                List<Analysis> analysisResult = new Jexl3Analysis(forExecute).compile();
                if (analysisResult.isEmpty()) {
                    forAnalysis.setForExecute(forExecute);
                } else {
                    forAnalysis.setForAnalyses(analysisResult);
                }
            }
            this.result.add(forAnalysis);
        }
    }

    private void ifElse() {
        String ifCondition = this.parentheses();
        if (Objects.nonNull(ifCondition)) {
            String elseExecute;
            if (this.sourceLanguageMatcher.start() > this.fromIndex) {
                this.result.add(new TxtAnalysis(this.sourceLanguage.substring(this.fromIndex, this.sourceLanguageMatcher.start())));
            }
            IfElseAnalysis ifElseAnalysis = new IfElseAnalysis();
            ifElseAnalysis.setIfCondition(ifCondition);
            String ifExecute = this.braces();
            if (Objects.nonNull(ifExecute)) {
                List<Analysis> analysisResult = new Jexl3Analysis(ifExecute).compile();
                if (analysisResult.isEmpty()) {
                    ifElseAnalysis.setIfExecute(ifExecute);
                } else {
                    ifElseAnalysis.setIfAnalyses(analysisResult);
                }
            }
            if (this.startElse() && Objects.nonNull(elseExecute = this.braces())) {
                List<Analysis> analysesResult = new Jexl3Analysis(elseExecute).compile();
                if (analysesResult.isEmpty()) {
                    ifElseAnalysis.setElseExecute(elseExecute);
                } else {
                    ifElseAnalysis.setElseAnalyses(analysesResult);
                }
            }
            this.result.add(ifElseAnalysis);
        }
    }

    public boolean startElse() {
        if (this.elseMatcher.find(this.position)) {
            boolean elseFlag = this.elseMatcher.group().equals("#else");
            if (elseFlag) {
                this.position += 5;
            }
            return elseFlag;
        }
        return false;
    }

    private String braces() {
        return this.findBrace('{', '}');
    }

    private String parentheses() {
        return this.findBrace('(', ')');
    }

    private int findLeftBrace(char chLeft, int fromIndex) {
        for (int index = fromIndex; index < this.sourceLanguage.length(); ++index) {
            char ch = this.sourceLanguage.charAt(index);
            if (ch == chLeft) {
                return index;
            }
            if (Character.isWhitespace(ch)) continue;
            return -1;
        }
        return -1;
    }

    private int findRightBrace(char chLeft, char chRight, int fromIndex) {
        int level = 0;
        for (int index = fromIndex; index < this.sourceLanguage.length(); ++index) {
            char ch = this.sourceLanguage.charAt(index);
            if (ch == chLeft) {
                ++level;
                continue;
            }
            if (ch != chRight) continue;
            if (level == 0) {
                return index;
            }
            --level;
        }
        return -1;
    }

    private String findBrace(char chLeft, char chRight) {
        int start;
        int end;
        int left = this.findLeftBrace(chLeft, this.position);
        if (left >= this.position && (end = this.findRightBrace(chLeft, chRight, start = left + 1)) >= start) {
            this.position = end + 1;
            return this.sourceLanguage.substring(start, end);
        }
        return null;
    }
}

