/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.util.date;

import cn.zhangfusheng.elasticsearch.constant.Regular;
import cn.zhangfusheng.elasticsearch.util.RegularUtil;
import cn.zhangfusheng.elasticsearch.util.date.enumeration.DateAddEnum;
import cn.zhangfusheng.elasticsearch.util.date.enumeration.DateFromatEnum;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;

public final class LocalDateTimeUtils {
    private static final String[] WEEKS = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};

    public static String nowTime(DateFromatEnum dateFromatEnum) {
        return LocalDateTimeUtils.format(LocalDateTime.now(), dateFromatEnum);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date localDateTimeToDate(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String format(LocalDateTime localDateTime, DateFromatEnum dateFromatEnum) {
        return localDateTime.format(dateFromatEnum.getFormatter());
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date date, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parse(String dateTime, DateFromatEnum dateFromatEnum) {
        if (DateFromatEnum.YYYY.equals((Object)dateFromatEnum)) {
            return Year.parse(dateTime, dateFromatEnum.getFormatter()).atDay(1).atStartOfDay();
        }
        if (DateFromatEnum.YYYY_MM.equals((Object)dateFromatEnum) || DateFromatEnum.YYYY_MM_1.equals((Object)dateFromatEnum) || DateFromatEnum.YYYY_MM_2.equals((Object)dateFromatEnum)) {
            return YearMonth.parse(dateTime, dateFromatEnum.getFormatter()).atDay(1).atStartOfDay();
        }
        if (DateFromatEnum.YYYY_MM_DD.equals((Object)dateFromatEnum) || DateFromatEnum.YYYY_MM_DD_1.equals((Object)dateFromatEnum) || DateFromatEnum.YYYY_MM_DD_2.equals((Object)dateFromatEnum)) {
            return LocalDate.parse(dateTime, dateFromatEnum.getFormatter()).atStartOfDay();
        }
        return LocalDateTime.parse(dateTime, dateFromatEnum.getFormatter());
    }

    public static LocalDateTime parseMatches(String dateTime) {
        if (RegularUtil.matches(dateTime, Regular.PATTERN_TIME_YYYY)) {
            return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.YYYY);
        }
        if (RegularUtil.matches(dateTime, Regular.PATTERN_TIME_YYYY_MM)) {
            return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.YYYY_MM);
        }
        if (RegularUtil.matches(dateTime, Regular.PATTERN_TIME_YYYY_MM_DD)) {
            return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.YYYY_MM_DD);
        }
        if (RegularUtil.matches(dateTime, Regular.PATTERN_TIME_UUUU_MM_DD_T_HH_MM_SS)) {
            return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.UUUU_MM_DD_T_HH_MM_SS);
        }
        if (RegularUtil.matches(dateTime, Regular.PATTERN_TIME_UUUU_MM_DD_T_HH_MM_SS_Z)) {
            return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.UUUU_MM_DD_T_HH_MM_SS_Z);
        }
        return LocalDateTimeUtils.parse(dateTime, DateFromatEnum.YYYY_MM_DD_HH_MM_SS);
    }

    public static LocalDateTime getStartTime(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().atStartOfDay();
    }

    public static LocalDateTime plus(LocalDateTime localDateTime, long amountToAdd, DateAddEnum dateAddEnum) {
        return localDateTime.plus(amountToAdd, dateAddEnum.getChronoUnit());
    }

    public static String getWeek(LocalDateTime localDateTime) {
        return WEEKS[localDateTime.getDayOfWeek().getValue()];
    }

    public static int getMonthDays(LocalDateTime localDateTime) {
        return localDateTime.getMonth().length(localDateTime.toLocalDate().isLeapYear());
    }

    public static boolean isLeapYear(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate().isLeapYear();
    }

    public static LocalDateTime getDayStart(LocalDateTime dateTime) {
        return dateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime getDayEnd(LocalDateTime dateTime) {
        return dateTime.with(LocalTime.MAX);
    }

    public static LocalDateTime getFirstDayOfMonth(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
    }

    public static LocalDateTime getLastDayOfMonth(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
    }

    public static LocalDateTime getFirstDayOfPreviousMonth(LocalDateTime dateTime, int previousMonth) {
        return dateTime.minusMonths(previousMonth).with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
    }

    public static LocalDateTime getLastDayOfPreviousMonth(LocalDateTime dateTime, int previousMonth) {
        return dateTime.minusMonths(previousMonth).with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
    }

    public static Long getTimeStamp(boolean isMilli) {
        return isMilli ? LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli() : LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
    }

    public static long getTimeStamp(LocalDateTime localDateTime, boolean isMilli) {
        return isMilli ? localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() : localDateTime.toEpochSecond(ZoneOffset.of("+8"));
    }

    public static LocalDate getFirtWeek(LocalDate localDate) {
        return localDate.with(DayOfWeek.MONDAY).with(LocalTime.MIN);
    }

    public static LocalDateTime getFirtWeek(LocalDateTime dateTime) {
        return dateTime.with(DayOfWeek.MONDAY).with(LocalTime.MIN);
    }

    public static LocalDateTime getPreviousFirstWeek(LocalDateTime dateTime, long previousWeek) {
        return dateTime.minusWeeks(previousWeek).with(DayOfWeek.MONDAY).with(LocalTime.MIN);
    }

    public static LocalDate getEndWeek(LocalDate localDate) {
        return localDate.with(DayOfWeek.SUNDAY).with(LocalTime.MAX);
    }

    public static LocalDateTime getEndWeek(LocalDateTime localDateTime) {
        return localDateTime.with(DayOfWeek.SUNDAY).with(LocalTime.MAX);
    }

    public static LocalDateTime getPreviousEndWeek(LocalDateTime dateTime, long previousWeek) {
        return dateTime.minusWeeks(previousWeek).with(DayOfWeek.SUNDAY).with(LocalTime.MAX);
    }

    public static int compareTo(String start, String end, DateFromatEnum dateFromatEnum) {
        LocalDateTime startDate = LocalDateTimeUtils.parse(start, dateFromatEnum);
        LocalDateTime endDate = LocalDateTimeUtils.parse(end, dateFromatEnum);
        return startDate.compareTo(endDate);
    }

    public static LocalDateTime getOnTheHour(LocalDateTime localDateTime, DateFromatEnum dateFromatEnum) {
        String format = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00:00"));
        return LocalDateTimeUtils.parse(format, dateFromatEnum);
    }

    public static LocalDateTime getYearStart() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.withYear(localDateTime.getYear()).withMonth(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
    }

    public static LocalDateTime getYearStart(Integer year) {
        return LocalDateTime.now().withYear(year).withMonth(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
    }

    public static LocalDateTime getMonthStart(Integer year, Integer month) {
        return LocalDateTime.now().withYear(year).withMonth(month).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
    }

    public static LocalDateTime getHourStart(LocalDateTime localDateTime) {
        return localDateTime.withMinute(0).withSecond(0);
    }
}

