/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.transfer;

import cn.zhangfusheng.elasticsearch.annotation.document.field.FieldMapping;
import cn.zhangfusheng.elasticsearch.annotation.document.field.MappingParameters;
import cn.zhangfusheng.elasticsearch.annotation.dsl.es.DslSearch;
import cn.zhangfusheng.elasticsearch.annotation.dsl.es.DslSortOrder;
import cn.zhangfusheng.elasticsearch.constant.enumeration.FieldType;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.util.date.LocalDateTimeUtils;
import cn.zhangfusheng.elasticsearch.util.date.enumeration.DateFromatEnum;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.sort.SortOrder;

public class TransferInfo {
    @FieldMapping(primaryId=true, type=FieldType.Keyword)
    private String rowId;
    private Boolean transfer;
    private String indexName;
    private String upIndexName;
    @DslSearch
    @FieldMapping(type=FieldType.Keyword)
    private String className;
    private Integer version;
    private String upgradeVersion;
    @DslSearch
    @FieldMapping(type=FieldType.Keyword)
    private String transferVersion;
    private String desc;
    @DslSortOrder(value=SortOrder.ASC)
    @FieldMapping(patameters={@MappingParameters(format="yyyy-MM-dd HH:mm:ss")})
    private LocalDateTime createTime;

    public TransferInfo(String rowId, Map<String, Object> sourceAsMap) {
        this.rowId = rowId;
        if (sourceAsMap.containsKey("indexName")) {
            this.indexName = String.valueOf(sourceAsMap.get("indexName"));
        }
        if (sourceAsMap.containsKey("upIndexName")) {
            this.upIndexName = String.valueOf(sourceAsMap.get("upIndexName"));
        }
        if (sourceAsMap.containsKey("className")) {
            this.className = String.valueOf(sourceAsMap.get("className"));
        }
        if (sourceAsMap.containsKey("upgradeVersion")) {
            this.upgradeVersion = String.valueOf(sourceAsMap.get("upgradeVersion"));
        }
        this.transfer = Boolean.parseBoolean(String.valueOf(sourceAsMap.get("transfer")));
        this.version = Integer.parseInt(String.valueOf(sourceAsMap.get("version")));
    }

    public TransferInfo() {
    }

    public XContentBuilder xContentBuilder(String rowId) {
        try {
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject();
            xContentBuilder.field("rowId", (String)StringUtils.defaultIfBlank((CharSequence)this.rowId, (CharSequence)rowId));
            if (StringUtils.isNotBlank((CharSequence)this.indexName)) {
                xContentBuilder.field("indexName", this.indexName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.upIndexName)) {
                xContentBuilder.field("upIndexName", this.upIndexName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.className)) {
                xContentBuilder.field("className", this.className);
            }
            if (StringUtils.isNotBlank((CharSequence)this.upgradeVersion)) {
                xContentBuilder.field("upgradeVersion", this.upgradeVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)this.transferVersion)) {
                xContentBuilder.field("transferVersion", this.transferVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)this.desc)) {
                xContentBuilder.field("desc", this.desc);
            }
            xContentBuilder.field("transfer", this.transfer);
            xContentBuilder.field("version", this.version);
            xContentBuilder.field("createTime", LocalDateTimeUtils.nowTime(DateFromatEnum.YYYY_MM_DD_HH_MM_SS));
            return xContentBuilder.endObject();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    public String getRowId() {
        return this.rowId;
    }

    public Boolean getTransfer() {
        return this.transfer;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getUpIndexName() {
        return this.upIndexName;
    }

    public String getClassName() {
        return this.className;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getUpgradeVersion() {
        return this.upgradeVersion;
    }

    public String getTransferVersion() {
        return this.transferVersion;
    }

    public String getDesc() {
        return this.desc;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public TransferInfo setRowId(String rowId) {
        this.rowId = rowId;
        return this;
    }

    public TransferInfo setTransfer(Boolean transfer) {
        this.transfer = transfer;
        return this;
    }

    public TransferInfo setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public TransferInfo setUpIndexName(String upIndexName) {
        this.upIndexName = upIndexName;
        return this;
    }

    public TransferInfo setClassName(String className) {
        this.className = className;
        return this;
    }

    public TransferInfo setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public TransferInfo setUpgradeVersion(String upgradeVersion) {
        this.upgradeVersion = upgradeVersion;
        return this;
    }

    public TransferInfo setTransferVersion(String transferVersion) {
        this.transferVersion = transferVersion;
        return this;
    }

    public TransferInfo setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public TransferInfo setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferInfo)) {
            return false;
        }
        TransferInfo other = (TransferInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$transfer = this.getTransfer();
        Boolean other$transfer = other.getTransfer();
        if (this$transfer == null ? other$transfer != null : !((Object)this$transfer).equals(other$transfer)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$rowId = this.getRowId();
        String other$rowId = other.getRowId();
        if (this$rowId == null ? other$rowId != null : !this$rowId.equals(other$rowId)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$upIndexName = this.getUpIndexName();
        String other$upIndexName = other.getUpIndexName();
        if (this$upIndexName == null ? other$upIndexName != null : !this$upIndexName.equals(other$upIndexName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$upgradeVersion = this.getUpgradeVersion();
        String other$upgradeVersion = other.getUpgradeVersion();
        if (this$upgradeVersion == null ? other$upgradeVersion != null : !this$upgradeVersion.equals(other$upgradeVersion)) {
            return false;
        }
        String this$transferVersion = this.getTransferVersion();
        String other$transferVersion = other.getTransferVersion();
        if (this$transferVersion == null ? other$transferVersion != null : !this$transferVersion.equals(other$transferVersion)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $transfer = this.getTransfer();
        result = result * 59 + ($transfer == null ? 43 : ((Object)$transfer).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $rowId = this.getRowId();
        result = result * 59 + ($rowId == null ? 43 : $rowId.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $upIndexName = this.getUpIndexName();
        result = result * 59 + ($upIndexName == null ? 43 : $upIndexName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $upgradeVersion = this.getUpgradeVersion();
        result = result * 59 + ($upgradeVersion == null ? 43 : $upgradeVersion.hashCode());
        String $transferVersion = this.getTransferVersion();
        result = result * 59 + ($transferVersion == null ? 43 : $transferVersion.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "TransferInfo(rowId=" + this.getRowId() + ", transfer=" + this.getTransfer() + ", indexName=" + this.getIndexName() + ", upIndexName=" + this.getUpIndexName() + ", className=" + this.getClassName() + ", version=" + this.getVersion() + ", upgradeVersion=" + this.getUpgradeVersion() + ", transferVersion=" + this.getTransferVersion() + ", desc=" + this.getDesc() + ", createTime=" + this.getCreateTime() + ")";
    }
}

