/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.transactional;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.thread.ThreadLocalDetail;
import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RethrottleRequest;
import org.elasticsearch.tasks.TaskId;

public class TransactionalControl {
    private final Class<? extends Throwable> rollbackFor;
    private final TaskId taskId;
    private final BulkRequest bulkRequest;
    private int requestNum;
    private int taskNum;
    private int waitExecute;

    public TransactionalControl(Class<? extends Throwable> rollbackFor, TaskId taskId) {
        this.rollbackFor = rollbackFor;
        this.taskId = taskId;
        this.bulkRequest = new BulkRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequest(DocWriteRequest<?> ... requests) {
        if (Objects.nonNull(requests) && requests.length > 0) {
            TransactionalControl transactionalControl = this;
            synchronized (transactionalControl) {
                this.bulkRequest.add(requests);
                this.requestNum += requests.length;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWaitExecute(int num) {
        TransactionalControl transactionalControl = this;
        synchronized (transactionalControl) {
            this.waitExecute += num;
            return this.waitExecute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskId getTaskId() {
        TransactionalControl transactionalControl = this;
        synchronized (transactionalControl) {
            ++this.taskNum;
        }
        return this.taskId;
    }

    public boolean rollbackFor(Throwable throwable) {
        return Objects.nonNull(throwable) && this.rollbackFor.isInstance(throwable);
    }

    public void commit(Throwable throwable, RestHighLevelClient restHighLevelClient) throws IOException {
        if (this.rollbackFor(throwable)) {
            return;
        }
        int waitExecute = this.addWaitExecute(-1);
        if (waitExecute == 0) {
            if (this.getRequestNum() > 0) {
                BulkRequest bulkRequest = this.getBulkRequest();
                ThreadLocalDetail.getRefreshPolicy().ifPresent(arg_0 -> ((BulkRequest)bulkRequest).setRefreshPolicy(arg_0));
                BulkResponse bulkResponse = restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                if (bulkResponse.hasFailures()) {
                    throw new GlobalSystemException(bulkResponse.buildFailureMessage());
                }
            }
            if (this.getTaskNum() > 0) {
                RethrottleRequest request = new RethrottleRequest(this.getTaskId());
                restHighLevelClient.reindexRethrottle(request, RequestOptions.DEFAULT);
                restHighLevelClient.updateByQueryRethrottle(request, RequestOptions.DEFAULT);
                restHighLevelClient.deleteByQueryRethrottle(request, RequestOptions.DEFAULT);
            }
            ThreadLocalDetail.remove();
        }
    }

    public Class<? extends Throwable> getRollbackFor() {
        return this.rollbackFor;
    }

    public BulkRequest getBulkRequest() {
        return this.bulkRequest;
    }

    public int getRequestNum() {
        return this.requestNum;
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public int getWaitExecute() {
        return this.waitExecute;
    }
}

