/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.annotation.dsl.es.DslSearch;
import cn.zhangfusheng.elasticsearch.annotation.dsl.es.DslSortOrder;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.function.DslSortOrderFunction;
import cn.zhangfusheng.elasticsearch.model.annotation.DefaultDslSearch;
import cn.zhangfusheng.elasticsearch.model.es.GeoDistance;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.model.page.PageResponse;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.util.CollectionUtils;

interface TemplateSearchApi
extends ElasticSearchTemplateApi,
Template {
    default public List<SearchHit> search(Object[] args, String routing, ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail) {
        String indexName = elasticSearchEntityRepositoryDetail.getIndexName();
        return this.search(args, routing, indexName);
    }

    default public List<SearchHit> search(Object[] args, String routing, String ... indices) {
        try {
            SearchRequest searchRequest = this.getSearchRequest(args, routing, indices);
            ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
            this.search(searchRequest, hs -> searchHits.addAll(Arrays.asList(hs)));
            return searchHits;
        }
        catch (Throwable e) {
            throw new GlobalSystemException(e);
        }
    }

    default public PageResponse<SearchHit> searchWithPage(Object[] args, String routing, ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail, PageRequest pageRequest) {
        String indexName = elasticSearchEntityRepositoryDetail.getIndexName();
        return this.searchWithPage(args, routing, pageRequest, indexName);
    }

    default public PageResponse<SearchHit> searchWithPage(Object[] args, String routing, PageRequest pageRequest, String ... indices) {
        PageResponse<SearchHit> pageResponse = new PageResponse<SearchHit>();
        ArrayList searchHits = new ArrayList(pageRequest.getSize());
        SearchResponse searchResponse = this.searchWithPage(hs -> searchHits.addAll(Arrays.asList(hs)), pageRequest, args, routing, indices);
        if (Objects.nonNull(searchResponse) && !CollectionUtils.isEmpty(searchHits)) {
            Object[] sortValues = ((SearchHit)searchHits.get(searchHits.size() - 1)).getSortValues();
            pageResponse.setTotal(searchResponse.getHits().getTotalHits()).setData(searchHits).setSearchAfter(sortValues);
        }
        pageResponse.setSkipTotal(pageRequest.getSkipTotal());
        return pageResponse;
    }

    default public SearchResponse searchWithPage(Consumer<SearchHit[]> consumer, PageRequest pageRequest, Object[] args, String routing, String ... indices) {
        try {
            SearchRequest searchRequest = this.getSearchRequest(args, routing, indices);
            return this.searchWithPage(searchRequest, pageRequest, consumer);
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public SearchRequest getSearchRequest(Object[] args, String routing, String ... indices) throws Exception {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        indices = this.analysisIndex(args, indices);
        SearchRequest searchRequest = new SearchRequest(indices).routing(routing).source(new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder));
        if (Objects.isNull(args) || args.length <= 0) {
            return searchRequest;
        }
        Iterator argsIterator = Arrays.stream(args).iterator();
        while (argsIterator.hasNext()) {
            Field[] declaredFields;
            Object arg = argsIterator.next();
            if (Objects.isNull(arg.getClass().getClassLoader())) {
                throw new GlobalSystemException("\u8bf7\u5c06\u53c2\u6570\u5c01\u88c5\u6210\u81ea\u5b9a\u4e49\u5b9e\u4f53\u8fdb\u884c\u4f7f\u7528");
            }
            for (Field declaredField : declaredFields = arg.getClass().getDeclaredFields()) {
                declaredField.setAccessible(true);
                Object value = declaredField.get(arg);
                this.buildSort(searchRequest, declaredField, value);
                if (Objects.isNull(value) || value instanceof String && StringUtils.isBlank((CharSequence)String.valueOf(value)) || value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value))) continue;
                this.buildSearch(boolQueryBuilder, searchRequest, declaredField, value);
            }
        }
        return searchRequest;
    }

    default public void buildSearch(BoolQueryBuilder boolQueryBuilder, SearchRequest searchRequest, Field declaredField, Object value) throws Exception {
        DslSearch dslSearch = Optional.ofNullable(declaredField.getAnnotation(DslSearch.class)).orElseGet(() -> DefaultDslSearch.INSTANCE);
        String fieldName = (String)StringUtils.defaultIfBlank((CharSequence)dslSearch.value(), (CharSequence)declaredField.getName());
        if (dslSearch.routing()) {
            searchRequest.routing(String.valueOf(value));
        }
        BoolQueryBuilder queryBuilder = Objects.nonNull(declaredField.getType().getClassLoader()) ? this.buildSearchWithEntity(searchRequest, declaredField, value) : dslSearch.keyword().getBuilder(fieldName, value);
        this.setQueryBuilder(dslSearch, (QueryBuilder)queryBuilder, boolQueryBuilder);
    }

    default public BoolQueryBuilder buildSearchWithEntity(SearchRequest searchRequest, Field declaredField, Object value) throws Exception {
        Class<?> type = declaredField.getType();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (Field declaredField_ : FieldUtils.getAllFields(type)) {
            declaredField_.setAccessible(true);
            Object value_ = declaredField_.get(value);
            this.buildSearch(boolQueryBuilder, searchRequest, declaredField_, value_);
        }
        return boolQueryBuilder;
    }

    default public void buildSort(SearchRequest searchRequest, Field declaredField, Object value) throws Exception {
        DslSortOrder dslSortOrder = declaredField.getAnnotation(DslSortOrder.class);
        if (Objects.nonNull(dslSortOrder)) {
            SortOrder sortOrder = dslSortOrder.value();
            Class<? extends DslSortOrderFunction> function = dslSortOrder.function();
            if (!function.equals(DslSortOrderFunction.class)) {
                sortOrder = function.newInstance().sort(value);
            }
            if (Objects.nonNull(sortOrder)) {
                String fieldName = (String)StringUtils.defaultIfBlank((CharSequence)dslSortOrder.fieldName(), (CharSequence)declaredField.getName());
                if (declaredField.getType().equals(GeoDistance.class) && Objects.nonNull(value)) {
                    GeoDistance geoDistance = (GeoDistance)value;
                    GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)fieldName, (double)geoDistance.getLat(), (double)geoDistance.getLon());
                    searchRequest.source().sort(geoDistanceSortBuilder.order(sortOrder));
                } else {
                    FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)fieldName);
                    searchRequest.source().sort(fieldSortBuilder.order(sortOrder));
                }
            }
        }
    }

    default public BoolQueryBuilder setQueryBuilder(DslSearch dslSearch, QueryBuilder queryBuilder, BoolQueryBuilder boolQueryBuilder) {
        switch (dslSearch.searchType()) {
            case FILTER: {
                return boolQueryBuilder.filter(queryBuilder);
            }
            case SHOULD: {
                return boolQueryBuilder.should(queryBuilder);
            }
        }
        return boolQueryBuilder.must(queryBuilder);
    }
}

