/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.template.Template;
import cn.zhangfusheng.elasticsearch.thread.ThreadLocalDetail;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RethrottleRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.tasks.TaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

interface TemplateDocumentApi
extends Template {
    public static final Logger log = LoggerFactory.getLogger(TemplateDocumentApi.class);

    default public boolean index(String id, String routing, String indexName, XContentBuilder xContentBuilder) {
        return this.index(new IndexRequest(indexName).routing(routing).id(id).source(xContentBuilder));
    }

    default public boolean index(String id, String routing, String indexName, Map<String, Object> sourceMap) {
        return this.index(new IndexRequest(indexName).routing(routing).id(id).source(sourceMap));
    }

    default public boolean index(IndexRequest request) {
        try {
            ThreadLocalDetail.getRefreshPolicy().ifPresent(arg_0 -> ((IndexRequest)request).setRefreshPolicy(arg_0));
            log.debug("save: {}", (Object)request);
            boolean addSuccess = ThreadLocalDetail.addReqeust(new DocWriteRequest[]{request.opType(DocWriteRequest.OpType.CREATE)});
            if (addSuccess) {
                return true;
            }
            IndexResponse indexResponse = this.restHighLevelClient().index(request, RequestOptions.DEFAULT);
            return Objects.equals(indexResponse.status(), RestStatus.CREATED);
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public GetResponse get(String index, String routing, String id, List<String> includes, List<String> excludes) {
        boolean ei;
        if (StringUtils.isBlank((CharSequence)index)) {
            throw new GlobalSystemException("\u5fc5\u987b\u6307\u5b9a\u7d22\u5f15");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        GetRequest request = new GetRequest(index, id).refresh(true);
        if (StringUtils.isNotBlank((CharSequence)routing)) {
            request.routing(routing);
        }
        boolean i = !CollectionUtils.isEmpty(includes);
        boolean bl = ei = !CollectionUtils.isEmpty(excludes);
        if (i || ei) {
            String[] includes_ = Strings.EMPTY_ARRAY;
            String[] excludes_ = Strings.EMPTY_ARRAY;
            if (i) {
                includes_ = includes.toArray(new String[0]);
            }
            if (ei) {
                excludes_ = excludes.toArray(new String[0]);
            }
            request.fetchSourceContext(new FetchSourceContext(true, includes_, excludes_));
        }
        log.debug("search: {}", (Object)request.toString());
        try {
            return this.restHighLevelClient().get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public boolean exists(String index, String routing, String id) {
        if (StringUtils.isBlank((CharSequence)index)) {
            throw new GlobalSystemException("\u5fc5\u987b\u6307\u5b9a\u7d22\u5f15");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalSystemException("\u8bf7\u6307\u5b9aid");
        }
        GetRequest request = new GetRequest(index, id).routing(routing);
        request.fetchSourceContext(new FetchSourceContext(false)).storedFields(new String[]{"_none_"});
        log.debug("exists: {}", (Object)request);
        try {
            return this.restHighLevelClient().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public boolean delete(String index, String routing, String id) {
        if (StringUtils.isBlank((CharSequence)index)) {
            throw new GlobalSystemException("\u5fc5\u987b\u6307\u5b9a\u7d22\u5f15");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalSystemException("\u8bf7\u6307\u5b9aid");
        }
        DeleteRequest request = new DeleteRequest(index, id).routing(routing);
        return this.delete(request);
    }

    default public boolean delete(DeleteRequest request) {
        ThreadLocalDetail.getRefreshPolicy().ifPresent(arg_0 -> ((DeleteRequest)request).setRefreshPolicy(arg_0));
        log.debug("delete: {}", (Object)request);
        boolean addSuccess = ThreadLocalDetail.addReqeust(new DocWriteRequest[]{request});
        if (addSuccess) {
            return true;
        }
        try {
            DeleteResponse deleteResponse = this.restHighLevelClient().delete(request, RequestOptions.DEFAULT);
            return deleteResponse.getResult() != DocWriteResponse.Result.NOT_FOUND;
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public boolean update(String index, String routing, String id, XContentBuilder xContentBuilder) {
        if (StringUtils.isBlank((CharSequence)index)) {
            throw new GlobalSystemException("\u5fc5\u987b\u6307\u5b9a\u7d22\u5f15");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new GlobalSystemException("\u8bf7\u6307\u5b9aid");
        }
        UpdateRequest request = new UpdateRequest(index, id).doc(xContentBuilder).routing(routing);
        return this.update(request);
    }

    default public boolean update(UpdateRequest request) {
        ThreadLocalDetail.getRefreshPolicy().ifPresent(arg_0 -> ((UpdateRequest)request).setRefreshPolicy(arg_0));
        log.debug("update: {}", (Object)request);
        boolean addSuccess = ThreadLocalDetail.addReqeust(new DocWriteRequest[]{request});
        if (addSuccess) {
            return true;
        }
        try {
            UpdateResponse updateResponse = this.restHighLevelClient().update(request, RequestOptions.DEFAULT);
            return updateResponse.getResult() != DocWriteResponse.Result.NOT_FOUND;
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public boolean bulkRequest(BulkRequest request) {
        ThreadLocalDetail.getRefreshPolicy().ifPresent(arg_0 -> ((BulkRequest)request).setRefreshPolicy(arg_0));
        log.debug(request.toString());
        try {
            BulkResponse bulkResponse = this.restHighLevelClient().bulk(request, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new GlobalSystemException(bulkResponse.buildFailureMessage());
            }
            return bulkResponse.hasFailures();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public void reindex(String targetIndex, String ... sourceIndex) {
        if (StringUtils.isBlank((CharSequence)targetIndex)) {
            throw new GlobalSystemException("\u8bf7\u8bbe\u7f6e\u76ee\u6807\u7d22\u5f15");
        }
        if (StringUtils.isAnyBlank((CharSequence[])sourceIndex)) {
            throw new GlobalSystemException("\u8bf7\u8bbe\u7f6e\u6e90\u7d22\u5f15");
        }
        ReindexRequest request = new ReindexRequest();
        request.setSourceIndices(sourceIndex).setDestIndex(targetIndex).setRefresh(true);
        log.debug(request.toString());
        try {
            this.restHighLevelClient().reindexAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                    log.debug(bulkByScrollResponse.toString());
                }

                public void onFailure(Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public long updateByQuery(QueryBuilder query, Script script, String routing, String ... index) {
        if (StringUtils.isAnyBlank((CharSequence[])index)) {
            throw new GlobalSystemException("\u8bf7\u6307\u5b9aindex");
        }
        UpdateByQueryRequest request = (UpdateByQueryRequest)new UpdateByQueryRequest(index).setQuery(query).setRouting(routing).setScript(script);
        ThreadLocalDetail.getTransactionTaskId().ifPresent(arg_0 -> ((UpdateByQueryRequest)request).setParentTask(arg_0));
        ThreadLocalDetail.getRefreshPolicy().ifPresent(refreshPolicy -> {
            UpdateByQueryRequest cfr_ignored_0 = (UpdateByQueryRequest)request.setRefresh(!Objects.equals(refreshPolicy, WriteRequest.RefreshPolicy.NONE));
        });
        try {
            log.debug("{\"query\":{},\"script\":{}}", (Object)ElasticSearchConstant.PATTERN.matcher(query.toString()).replaceAll(""), (Object)JSON.toJSONString((Object)script));
            BulkByScrollResponse bulkByScrollResponse = this.restHighLevelClient().updateByQuery(request, RequestOptions.DEFAULT);
            return bulkByScrollResponse.getUpdated();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public long deleteByQuery(QueryBuilder query, String routing, String ... index) {
        if (StringUtils.isAnyBlank((CharSequence[])index)) {
            throw new GlobalSystemException("\u8bf7\u6307\u5b9aindex");
        }
        DeleteByQueryRequest request = new DeleteByQueryRequest(index).setQuery(query).setRouting(routing);
        log.debug(request.toString());
        ThreadLocalDetail.getTransactionTaskId().ifPresent(arg_0 -> ((DeleteByQueryRequest)request).setParentTask(arg_0));
        ThreadLocalDetail.getRefreshPolicy().ifPresent(refreshPolicy -> {
            DeleteByQueryRequest cfr_ignored_0 = (DeleteByQueryRequest)request.setRefresh(!Objects.equals(refreshPolicy, WriteRequest.RefreshPolicy.NONE));
        });
        try {
            BulkByScrollResponse bulkByScrollResponse = this.restHighLevelClient().deleteByQuery(request, RequestOptions.DEFAULT);
            return bulkByScrollResponse.getDeleted();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public void rethrottle() {
        Optional<TaskId> transactionTaskId = ThreadLocalDetail.getTransactionTaskId();
        transactionTaskId.ifPresent(taskId -> {
            RethrottleRequest request = new RethrottleRequest(taskId);
            log.debug(request.toString());
            try {
                this.restHighLevelClient().reindexRethrottle(request, RequestOptions.DEFAULT);
                this.restHighLevelClient().updateByQueryRethrottle(request, RequestOptions.DEFAULT);
                this.restHighLevelClient().deleteByQueryRethrottle(request, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new GlobalSystemException(e);
            }
        });
    }

    default public void createIndexMapping(String indexName, String mapping, String setting) {
        try {
            boolean acknowledged;
            log.debug("create new index:[{}],mapping:{}", (Object)indexName, (Object)mapping);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).mapping(mapping, XContentType.JSON);
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                createIndexRequest.settings(setting, XContentType.JSON);
            }
            if (!(acknowledged = this.restHighLevelClient().indices().create(createIndexRequest, RequestOptions.DEFAULT).isAcknowledged())) {
                throw new GlobalSystemException("\u521b\u5efaindex:[{}]\u7684mapping\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public void putMapping(String indexName, String mapping) {
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{indexName}).source(mapping, XContentType.JSON);
            boolean acknowledged = this.restHighLevelClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT).isAcknowledged();
            log.debug("create index:{} mapping:{}, success?{}", new Object[]{indexName, mapping, acknowledged});
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public boolean exists(GetIndexRequest getIndexRequest) {
        try {
            return this.restHighLevelClient().indices().exists(getIndexRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }
}

