/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.es.PutPipeline;
import cn.zhangfusheng.elasticsearch.template.Template;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public interface TemplageIngestApi
extends Template {
    public static final Logger log = LoggerFactory.getLogger(TemplageIngestApi.class);

    default public List<PipelineConfiguration> getPipeline(String ... id) {
        GetPipelineRequest getPipelineRequest = new GetPipelineRequest(id);
        log.debug("getPipeLine:{}", Arrays.stream(id).toArray());
        try {
            GetPipelineResponse response = this.restHighLevelClient().ingest().getPipeline(getPipelineRequest, RequestOptions.DEFAULT);
            return response.pipelines();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public void putPipeline(PutPipeline putPipeline) {
        List<PipelineConfiguration> pipeline = this.getPipeline(putPipeline.getId());
        if (CollectionUtils.isEmpty(pipeline)) {
            PutPipelineRequest putPipelineRequest = new PutPipelineRequest(putPipeline.getId(), (BytesReference)new BytesArray(putPipeline.source().getBytes(StandardCharsets.UTF_8)), XContentType.JSON);
            log.debug("createPipeline:{}", (Object)putPipelineRequest);
            try {
                AcknowledgedResponse acknowledgedResponse = this.restHighLevelClient().ingest().putPipeline(putPipelineRequest, RequestOptions.DEFAULT);
                if (!acknowledgedResponse.isAcknowledged()) {
                    throw new GlobalSystemException("\u521b\u5efa\u7ba1\u9053\u5931\u8d25");
                }
            }
            catch (IOException e) {
                throw new GlobalSystemException(e);
            }
        }
    }

    default public void delPipeline(String id) {
        DeletePipelineRequest deletePipelineRequest = new DeletePipelineRequest(id);
        try {
            AcknowledgedResponse acknowledgedResponse = this.restHighLevelClient().ingest().deletePipeline(deletePipelineRequest, RequestOptions.DEFAULT);
            if (!acknowledgedResponse.isAcknowledged()) {
                throw new GlobalSystemException("\u5220\u9664\u7ba1\u9053\u5931\u8d25");
            }
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }
}

