/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.setting;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SettingJsonConfig {
    private final Map<String, String> cache = new HashMap<String, String>();

    public SettingJsonConfig(Set<String> scanPath) {
        try {
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (String path : scanPath) {
                Resource[] resources;
                for (Resource resource : resources = pathMatchingResourcePatternResolver.getResources(path)) {
                    try (InputStream inputStream = resource.getInputStream();){
                        JSONObject fileDetail = (JSONObject)JSON.parseObject((InputStream)inputStream, JSONObject.class, (Feature[])new Feature[0]);
                        if (!fileDetail.containsKey((Object)"name") || !fileDetail.containsKey((Object)"settings")) {
                            throw new GlobalSystemException("setting json file must containsKey:[{},{}]", "name", "settings");
                        }
                        this.cache.put(fileDetail.getString("name"), fileDetail.getJSONObject("settings").toJSONString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    public String getSetting(String settingName) {
        return this.cache.get(settingName);
    }
}

