/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.scan;

import cn.zhangfusheng.elasticsearch.annotation.document.IndexDiscription;
import cn.zhangfusheng.elasticsearch.annotation.document.IndexSetting;
import cn.zhangfusheng.elasticsearch.annotation.document.IndexTransfer;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.repository.DefaultRepository;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.setting.SettingJsonConfig;
import cn.zhangfusheng.elasticsearch.transfer.TransferInfoRepository;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;

public class ElasticSearchEntityRepositoryFilter
extends AbstractClassTestingTypeFilter {
    private final String interfaceClassName;
    private final SettingJsonConfig settingJsonConfig;
    private final List<ElasticSearchEntityRepositoryDetail> entityRepositoryDetails = new ArrayList<ElasticSearchEntityRepositoryDetail>();
    private final List<Class<?>> entityClassCache = new ArrayList();

    public ElasticSearchEntityRepositoryFilter(Class<?> aClass, SettingJsonConfig settingJsonConfig) {
        this.interfaceClassName = aClass.getName();
        this.settingJsonConfig = settingJsonConfig;
    }

    protected boolean match(ClassMetadata metadata) {
        boolean b;
        String[] interfaceNames = metadata.getInterfaceNames();
        boolean bl = b = !metadata.getClassName().equals(ElasticSearchRepository.class.getName()) && !metadata.getClassName().equals(DefaultRepository.class.getName()) && !metadata.getClassName().equals(TransferInfoRepository.class.getName()) && Arrays.asList(interfaceNames).contains(this.interfaceClassName);
        if (b) {
            this.analysis(metadata);
        }
        return b;
    }

    private void analysis(ClassMetadata metadata) {
        try {
            Class entityClass = null;
            Class<?> repositoryClass = Class.forName(metadata.getClassName());
            Type[] genericInterfaces = repositoryClass.getGenericInterfaces();
            if (genericInterfaces.length != 1) {
                throw new GlobalSystemException("\u63a5\u53e3::{}::\u7ee7\u627f\u7684\u63a5\u53e3\u4e2a\u6570\u4e0d\u7b49\u4e8e1", repositoryClass.getName());
            }
            Type genericInterface = genericInterfaces[0];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 1) {
                    throw new GlobalSystemException("\u63a5\u53e3::{}::\u7684\u6cdb\u578b\u4e2a\u6570\u4e0d\u7b49\u4e8e1", repositoryClass.getName());
                }
                Type actualTypeArgument = actualTypeArguments[0];
                if (actualTypeArgument instanceof Class) {
                    entityClass = (Class)actualTypeArgument;
                }
            }
            if (Objects.isNull(entityClass)) {
                throw new GlobalSystemException("{}::\u89e3\u6790\u5931\u8d25,\u8bf7\u68c0\u67e5\u4e66\u5199\u662f\u5426\u7b26\u5408\u89c4\u8303", repositoryClass.getName());
            }
            if (Objects.isNull(entityClass.getAnnotation(IndexDiscription.class))) {
                throw new GlobalSystemException("{}::\u672a\u6dfb\u52a0\u6ce8\u89e3 IndexDiscription", entityClass);
            }
            IndexDiscription indexDiscription = entityClass.getAnnotation(IndexDiscription.class);
            IndexTransfer indexTransfer = entityClass.getAnnotation(IndexTransfer.class);
            IndexSetting indexSetting = entityClass.getAnnotation(IndexSetting.class);
            String setting = this.settingJsonConfig.getSetting(Optional.ofNullable(indexSetting).isPresent() ? indexSetting.settingName() : null);
            ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail = new ElasticSearchEntityRepositoryDetail(this.entityClassCache.contains(entityClass), repositoryClass, entityClass, indexDiscription, indexTransfer, setting);
            this.entityRepositoryDetails.add(elasticSearchEntityRepositoryDetail);
            this.entityClassCache.add(entityClass);
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    public List<ElasticSearchEntityRepositoryDetail> getEntityRepositoryDetails() {
        return this.entityRepositoryDetails;
    }
}

