/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.repository;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.repository.DefaultRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import java.util.Optional;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface DefaultElasticSearchEditRepository<T>
extends DefaultRepository<T> {
    @Override
    default public boolean insert(T t) {
        ElasticSearchEntityRepositoryDetail entityRepositoryDetail = this.entityRepositoryDetail();
        String id = entityRepositoryDetail.primaryIdIfNullSet(t);
        String routing = entityRepositoryDetail.routing(t);
        entityRepositoryDetail.setCreateTime(t).setUpdateTime(t);
        String indexName = entityRepositoryDetail.getIndexName();
        XContentBuilder xContentBuilder = entityRepositoryDetail.entityToXContentBuilder(t, Boolean.FALSE);
        return this.elasticSearchRestTemplate().index(id, routing, indexName, xContentBuilder);
    }

    @Override
    default public boolean updateById(T t, boolean excludeNull) {
        ElasticSearchEntityRepositoryDetail entityRepositoryDetail = this.entityRepositoryDetail();
        Optional<String> idOption = entityRepositoryDetail.primaryId(t);
        String id = idOption.orElseThrow(() -> new GlobalSystemException("primaryId {} is null", entityRepositoryDetail.getPrimaryId().getName()));
        String indexName = entityRepositoryDetail.getIndexName();
        String routing = entityRepositoryDetail.routing(t);
        entityRepositoryDetail.setUpdateTime(t);
        XContentBuilder xContentBuilder = entityRepositoryDetail.entityToXContentBuilder(t, excludeNull);
        return this.elasticSearchRestTemplate().update(indexName, routing, id, xContentBuilder);
    }

    @Override
    default public boolean deleteById(String primaryId) {
        return this.deleteById(primaryId, null);
    }

    @Override
    default public boolean deleteById(String primaryId, String routing) {
        String indexName = this.entityRepositoryDetail().getIndexName();
        return this.elasticSearchRestTemplate().delete(indexName, routing, primaryId);
    }
}

