/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.page;

import cn.zhangfusheng.elasticsearch.model.page.SkipPageModel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PageRequest {
    public static final PageRequest DEFAULT = new PageRequest(0, 10);
    public static final PageRequest SEARCH_ONE = new PageRequest(0, 1);
    private Integer from = 1;
    private Integer size = 10;
    private Object[] searchAfter;
    private List<SkipPageModel> skipPage;
    private int skipTotal;

    public PageRequest(int from, int size) {
        this.from = from;
        this.size = size;
    }

    public PageRequest(int form, int size, Object[] searchAfter) {
        this.from = form;
        this.size = size;
        this.searchAfter = searchAfter;
    }

    public Integer getFrom() {
        if (Objects.isNull(this.from)) {
            return null;
        }
        if (this.from <= 0) {
            return 0;
        }
        return (this.from - 1) * this.size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Object[] getSearchAfter() {
        return this.searchAfter;
    }

    public List<SkipPageModel> getSkipPage() {
        return this.skipPage;
    }

    public int getSkipTotal() {
        return this.skipTotal;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setSearchAfter(Object[] searchAfter) {
        this.searchAfter = searchAfter;
    }

    public void setSkipPage(List<SkipPageModel> skipPage) {
        this.skipPage = skipPage;
    }

    public void setSkipTotal(int skipTotal) {
        this.skipTotal = skipTotal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSkipTotal() != other.getSkipTotal()) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSearchAfter(), other.getSearchAfter())) {
            return false;
        }
        List<SkipPageModel> this$skipPage = this.getSkipPage();
        List<SkipPageModel> other$skipPage = other.getSkipPage();
        return !(this$skipPage == null ? other$skipPage != null : !((Object)this$skipPage).equals(other$skipPage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSkipTotal();
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSearchAfter());
        List<SkipPageModel> $skipPage = this.getSkipPage();
        result = result * 59 + ($skipPage == null ? 43 : ((Object)$skipPage).hashCode());
        return result;
    }

    public String toString() {
        return "PageRequest(from=" + this.getFrom() + ", size=" + this.getSize() + ", searchAfter=" + Arrays.deepToString(this.getSearchAfter()) + ", skipPage=" + this.getSkipPage() + ", skipTotal=" + this.getSkipTotal() + ")";
    }

    public PageRequest(Integer from, Integer size, Object[] searchAfter, List<SkipPageModel> skipPage, int skipTotal) {
        this.from = from;
        this.size = size;
        this.searchAfter = searchAfter;
        this.skipPage = skipPage;
        this.skipTotal = skipTotal;
    }

    public PageRequest() {
    }
}

