/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.analysis;

import cn.zhangfusheng.elasticsearch.annotation.document.field.FieldMapping;
import cn.zhangfusheng.elasticsearch.annotation.document.field.MappingParameters;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.Alias;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.FieldData;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.FieldDataFrequencyFilter;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.GeoPoint;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.IndexPrefixes;
import cn.zhangfusheng.elasticsearch.constant.enumeration.FieldType;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.annotation.DefaultFieldMapping;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.springframework.core.annotation.AnnotationUtils;

public class AnalysisMapping {
    private final List<Field> entityDeclaredFields;

    public AnalysisMapping(List<Field> entityDeclaredFields) {
        this.entityDeclaredFields = entityDeclaredFields;
    }

    public void builder(XContentBuilder xContentBuilder) throws IOException {
        for (Field field : this.entityDeclaredFields) {
            FieldMapping fieldMapping = Optional.ofNullable(field.getAnnotation(FieldMapping.class)).orElse(DefaultFieldMapping.INSTANCE);
            if (fieldMapping.ignore()) continue;
            boolean isDate = field.getType().equals(Date.class) || field.getType().equals(LocalDateTime.class);
            FieldType esFieldType = FieldType.Text;
            if (isDate) {
                esFieldType = FieldType.Date;
            } else if (Objects.nonNull((Object)fieldMapping.type())) {
                esFieldType = fieldMapping.type().equals((Object)FieldType.Default) ? this.getEsType(field.getType().getSimpleName()) : fieldMapping.type();
            }
            xContentBuilder.startObject(field.getName());
            this.builderType(xContentBuilder, esFieldType);
            this.builderPatameters(fieldMapping.patameters(), xContentBuilder);
            this.builderGeoPoint(fieldMapping.geoPoints(), esFieldType, xContentBuilder);
            this.builderAlias(fieldMapping.alias(), esFieldType, xContentBuilder);
            xContentBuilder.endObject();
        }
    }

    private void builderAlias(Alias[] alias, FieldType esFieldType, XContentBuilder xContentBuilder) throws IOException {
        if (esFieldType.equals((Object)FieldType.Alias)) {
            if (alias.length != 1) {
                throw new GlobalSystemException("must config FieldMapping alias and lenght == 1");
            }
            String path = alias[0].path();
            if (StringUtils.isBlank((CharSequence)path)) {
                throw new GlobalSystemException("FieldMapping alias path is blank");
            }
            xContentBuilder.field("path", path);
        }
    }

    private void builderGeoPoint(GeoPoint[] geoPoints, FieldType esFieldType, XContentBuilder xContentBuilder) throws IOException {
        if (geoPoints.length == 0) {
            return;
        }
        if (geoPoints.length > 1) {
            throw new GlobalSystemException("FieldMapping geoPoints length > 1");
        }
        if (esFieldType.equals((Object)FieldType.Geo_Point)) {
            GeoPoint geoPoint = geoPoints[0];
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)geoPoint);
            for (String key : annotationAttributes.keySet()) {
                Object value = annotationAttributes.get(key);
                if (value instanceof Long) {
                    long vl = (Long)value;
                    if (vl == -1L) continue;
                    xContentBuilder.field(key, vl == 1L);
                    continue;
                }
                if (!(value instanceof String) || !StringUtils.isNotBlank((CharSequence)String.valueOf(value))) continue;
                xContentBuilder.field(key, value);
            }
        } else {
            throw new GlobalSystemException("FieldType not equals FieldType.GeoPoint,not config GeoPoint");
        }
    }

    private void builderPatameters(MappingParameters[] patameters, XContentBuilder xContentBuilder) throws IOException {
        if (patameters.length == 0) {
            return;
        }
        if (patameters.length > 1) {
            throw new GlobalSystemException("MappingParatemers \u7684\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e1");
        }
        this.builderPatameters(xContentBuilder, patameters[0]);
    }

    private void builderPatameters(XContentBuilder xContentBuilder, MappingParameters patameter) throws IOException {
        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)patameter);
        for (String k : annotationAttributes.keySet()) {
            Object v = annotationAttributes.get(k);
            if (v instanceof String) {
                if (!StringUtils.isNotBlank((CharSequence)String.valueOf(v))) continue;
                xContentBuilder.field(k, v);
                continue;
            }
            if (v instanceof Long) {
                if (v.equals(-1L)) continue;
                xContentBuilder.field(k, v.equals(1L));
                continue;
            }
            if (v instanceof Integer) {
                if (v.equals(-1)) continue;
                xContentBuilder.field(k, v);
                continue;
            }
            if (!v.getClass().isArray()) continue;
            Class<?> componentType = v.getClass().getComponentType();
            if (componentType.equals(String.class)) {
                Object[] objects;
                String[] strs = (String[])v;
                if (strs.length <= 0 || (objects = Arrays.stream(strs).filter(StringUtils::isNotBlank).toArray()).length <= 0) continue;
                xContentBuilder.field(k, (Object)objects);
                continue;
            }
            if (componentType.equals(Class.class)) {
                this.builderWithClass(xContentBuilder, k, (Class[])v);
                continue;
            }
            if (componentType.equals(FieldData.class)) {
                this.builderFieldData(xContentBuilder, k, (FieldData[])v);
                continue;
            }
            if (!componentType.equals(IndexPrefixes.class)) continue;
            this.builderIndexPrefixes(xContentBuilder, k, (IndexPrefixes[])v);
        }
    }

    private void builderWithClass(XContentBuilder xContentBuilder, String key, Class<?>[] vs) throws IOException {
        if (vs.length <= 0) {
            return;
        }
        xContentBuilder.startObject(key);
        if (Objects.equals(key, "fields") || Objects.equals(key, "properties")) {
            for (Class<?> aClass : vs) {
                Field[] declaredFields = aClass.getDeclaredFields();
                new AnalysisMapping(Arrays.asList(declaredFields)).builder(xContentBuilder);
            }
        }
        xContentBuilder.endObject();
    }

    private void builderIndexPrefixes(XContentBuilder xContentBuilder, String key, IndexPrefixes[] indexPrefixes) throws IOException {
        if (indexPrefixes.length == 0) {
            return;
        }
        if (indexPrefixes.length > 1) {
            throw new GlobalSystemException("MappingParameters.indexPrefixes lenght >1");
        }
        Map indexPrefixAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)indexPrefixes[0]);
        xContentBuilder.startObject(key);
        for (String k : indexPrefixAttributes.keySet()) {
            xContentBuilder.field(k, indexPrefixAttributes.get(k));
        }
        xContentBuilder.endObject();
    }

    private void builderFieldData(XContentBuilder xContentBuilder, String key, FieldData[] fieldData) throws IOException {
        if (fieldData.length == 0) {
            return;
        }
        if (fieldData.length > 1) {
            throw new GlobalSystemException("MappingParameters.fielddata lenght >1");
        }
        xContentBuilder.field(key, fieldData[0].fielddata());
        FieldDataFrequencyFilter[] fieldDataFrequencyFilters = fieldData[0].fielddata_frequency_filter();
        if (fieldDataFrequencyFilters.length == 1) {
            xContentBuilder.startObject("fielddata_frequency_filter");
            FieldDataFrequencyFilter fieldDataFrequencyFilter = fieldDataFrequencyFilters[0];
            Map fieldDataFrequencyFilterAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)fieldDataFrequencyFilter);
            for (String k : fieldDataFrequencyFilterAttributes.keySet()) {
                xContentBuilder.field(k, fieldDataFrequencyFilterAttributes.get(k));
            }
            xContentBuilder.endObject();
        } else if (fieldDataFrequencyFilters.length > 1) {
            throw new GlobalSystemException("MappingParameters.fielddata.fielddata_frequency_filter lenght >1");
        }
    }

    private XContentBuilder builderType(XContentBuilder xContentBuilder, FieldType fieldType) throws IOException {
        switch (fieldType) {
            case Text: {
                return xContentBuilder.field("type", "text");
            }
            case Keyword: {
                return xContentBuilder.field("type", "keyword");
            }
            case Long: {
                return xContentBuilder.field("type", "long");
            }
            case Integer: {
                return xContentBuilder.field("type", "integer");
            }
            case Short: {
                return xContentBuilder.field("type", "short");
            }
            case Byte: {
                return xContentBuilder.field("type", "byte");
            }
            case Double: {
                return xContentBuilder.field("type", "double");
            }
            case Float: {
                return xContentBuilder.field("type", "float");
            }
            case Half_Float: {
                return xContentBuilder.field("type", "half_float");
            }
            case Scaled_Float: {
                return xContentBuilder.field("type", "scaled_float");
            }
            case Boolean: {
                return xContentBuilder.field("type", "boolean");
            }
            case Binary: {
                return xContentBuilder.field("type", "binary");
            }
            case Date: {
                return xContentBuilder.field("type", "date");
            }
            case Date_Nanos: {
                return xContentBuilder.field("type", "date_nanos");
            }
            case Integer_Range: {
                return xContentBuilder.field("type", "integer_range");
            }
            case Float_Range: {
                return xContentBuilder.field("type", "float_range");
            }
            case Long_Range: {
                return xContentBuilder.field("type", "long_range");
            }
            case Double_Range: {
                return xContentBuilder.field("type", "double_range");
            }
            case Date_Range: {
                return xContentBuilder.field("type", "date_range");
            }
            case Object: {
                return xContentBuilder;
            }
            case Nested: {
                return xContentBuilder.field("type", "nested");
            }
            case Geo_Point: {
                return xContentBuilder.field("type", "geo_point");
            }
            case Flattened: {
                return xContentBuilder.field("type", "flattened");
            }
            case Alias: {
                return xContentBuilder.field("type", "alias");
            }
            case Arrays: {
                return xContentBuilder;
            }
            case Wildcard: {
                return xContentBuilder.field("type", "wildcard");
            }
        }
        throw new GlobalSystemException("");
    }

    private FieldType getEsType(String fieldTypeName) {
        switch (fieldTypeName.toLowerCase()) {
            case "date": 
            case "localdatetime": {
                return FieldType.Date;
            }
            case "string": {
                return FieldType.Text;
            }
            case "boolean": {
                return FieldType.Boolean;
            }
            case "int": 
            case "integer": {
                return FieldType.Integer;
            }
            case "long": {
                return FieldType.Long;
            }
            case "short": {
                return FieldType.Short;
            }
            case "byte": {
                return FieldType.Byte;
            }
            case "double": {
                return FieldType.Double;
            }
            case "float": {
                return FieldType.Float;
            }
        }
        throw new GlobalSystemException("\u6682\u4e0d\u652f\u6301\u7684\u7c7b\u578b[{}],\u5339\u914d\u5931\u8d25", fieldTypeName);
    }
}

