/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.factory.proxy;

import cn.zhangfusheng.elasticsearch.annotation.dsl.dynamic.Dynamic;
import cn.zhangfusheng.elasticsearch.annotation.dsl.mybatis.DslWithMybatis;
import cn.zhangfusheng.elasticsearch.annotation.dsl.sql.DslWithSql;
import cn.zhangfusheng.elasticsearch.mybatis.ElasticSearchWithMybatisXmlConfig;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchRestTemplate;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class RepositoryProxy<T extends ElasticSearchRepository<?>> {
    private static final List<Method> DEFAULT_ELASTIC_SEARCH_REPOSITORY_METHODS = Arrays.asList(ElasticSearchRepository.class.getMethods());
    private final ElasticSearchEntityRepositoryDetail entityRepositoryDetail;
    private final ElasticSearchRestTemplate elasticSearchRestTemplate;
    private final ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig;
    private final String toString;

    public RepositoryProxy(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, ElasticSearchRestTemplate elasticSearchRestTemplate, ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig) {
        this.entityRepositoryDetail = entityRepositoryDetail;
        this.elasticSearchRestTemplate = elasticSearchRestTemplate;
        this.elasticSearchWithMybatisXmlConfig = elasticSearchWithMybatisXmlConfig;
        this.toString = String.format("%s@%s", entityRepositoryDetail.getElasticSearchRepositoryClass().getName(), System.identityHashCode(this));
    }

    public abstract T getObject();

    public Object getResult(Method method, Object[] args) {
        args = this.excludeEmpty(args);
        Map<String, Object> params = this.analysisMethodParams(args, method, this.entityRepositoryDetail.getMethodParamsIndex());
        String routing = this.entityRepositoryDetail.routing(params);
        String index = this.entityRepositoryDetail.getIndexName();
        Class<?> entityClass = this.entityRepositoryDetail.getEntityClass();
        DslWithMybatis dslWithMybatis = method.getAnnotation(DslWithMybatis.class);
        DslWithSql dslWithSql = method.getAnnotation(DslWithSql.class);
        Dynamic dynamic = method.getAnnotation(Dynamic.class);
        if (Objects.nonNull(dslWithMybatis)) {
            return this.elasticSearchRestTemplate.runIbatis(this.entityRepositoryDetail, method, args, params, routing, dslWithMybatis, this.elasticSearchWithMybatisXmlConfig, index);
        }
        if (Objects.nonNull(dslWithSql)) {
            return this.elasticSearchRestTemplate.runWithSql(this.entityRepositoryDetail, method, args, routing, index);
        }
        if (Objects.nonNull(dynamic)) {
            return this.elasticSearchRestTemplate.runDynamicStr(this.entityRepositoryDetail, method, args, routing, index);
        }
        return this.elasticSearchRestTemplate.runJpa(this.entityRepositoryDetail, method, args, routing, entityClass, index);
    }

    public boolean isDefaultMethod(Method method) {
        return DEFAULT_ELASTIC_SEARCH_REPOSITORY_METHODS.contains(method);
    }

    public Object[] excludeEmpty(Object[] args) {
        return Arrays.stream(args).map(arg -> {
            if (arg instanceof String ? StringUtils.isNotBlank((CharSequence)String.valueOf(arg)) : (arg instanceof Map ? !CollectionUtils.isEmpty((Map)((Map)arg)) : (arg instanceof Collection ? !CollectionUtils.isEmpty((Collection)((Collection)arg)) : Objects.nonNull(arg)))) {
                return arg;
            }
            return null;
        }).toArray();
    }

    public Map<String, Object> analysisMethodParams(Object[] args, Method method, Map<Method, Map<Integer, String>> methodParamsIndex) {
        Map<Integer, String> paramIndex = methodParamsIndex.get(method);
        HashMap<String, Object> result = new HashMap<String, Object>(paramIndex.size());
        paramIndex.forEach((index, paramName) -> result.put((String)paramName, args[index]));
        return result;
    }

    public String toString() {
        return this.toString;
    }
}

