/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.dynamic.sql.es;

import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import java.util.Objects;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class QueryOrderByParser
implements QueryParser {
    public void parse(ElasticDslContext dslContext) {
        if (dslContext.getSqlContext().selectOperation() != null && dslContext.getSqlContext().selectOperation().groupByClause() == null && dslContext.getSqlContext().selectOperation().orderClause() != null) {
            ElasticsearchParser.OrderClauseContext orderClauseContext = dslContext.getSqlContext().selectOperation().orderClause();
            for (ElasticsearchParser.OrderContext orderContext : orderClauseContext.order()) {
                ElasticsearchParser.NameClauseContext nameContext = orderContext.nameClause();
                if (!(nameContext instanceof ElasticsearchParser.FieldNameContext)) continue;
                ElasticsearchParser.FieldNameContext fieldNameContext = (ElasticsearchParser.FieldNameContext)nameContext;
                String field = fieldNameContext.field.getText();
                if (fieldNameContext.highlighter != null) {
                    dslContext.getParseResult().getHighlighter().add(field);
                }
                SortOrder sortOrder = Objects.isNull(orderContext.ASC()) ? SortOrder.DESC : SortOrder.ASC;
                SortBuilder sortBuilder = SortBuilders.fieldSort((String)field).order(sortOrder);
                dslContext.getParseResult().getOrderBy().add(sortBuilder);
            }
        }
    }
}

