/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.dynamic;

import cn.zhangfusheng.elasticsearch.annotation.dsl.dynamic.Dynamic;
import cn.zhangfusheng.elasticsearch.annotation.dsl.dynamic.condition.DynamicCondition;
import cn.zhangfusheng.elasticsearch.dynamic.DyanmicExecuteResult;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Analysis;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Execute;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DynamicAnalysisDetail {
    private final Map<String, Object> constantParams;
    private final Map<String, Integer> parameterNames;
    private final List<Analysis> analyses;
    private final Dynamic dynamic;
    private final List<DynamicCondition> dynamicConditions;
    private final Map<DynamicCondition, List<Analysis>> conditionAnalysis;

    public DynamicAnalysisDetail(Map<String, Object> constantParams, List<String> parameterNames, List<Analysis> analyses, Dynamic dynamic) {
        this.constantParams = constantParams;
        this.analyses = analyses;
        this.dynamic = dynamic;
        this.dynamicConditions = Arrays.asList(dynamic.conditions());
        this.conditionAnalysis = this.dynamicConditions.stream().collect(Collectors.toMap(o -> o, o -> new Jexl3Analysis(o.value()).compile()));
        this.parameterNames = new HashMap<String, Integer>(parameterNames.size());
        for (int i = 0; i < parameterNames.size(); ++i) {
            this.parameterNames.put(parameterNames.get(i), i);
        }
    }

    public DyanmicExecuteResult execute(Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>(this.parameterNames.size());
        this.parameterNames.forEach((k, v) -> params.put((String)k, args[v]));
        StringBuilder result = new StringBuilder();
        ArrayList<Object> resultParams = new ArrayList<Object>(args.length);
        Jexl3Execute jexl3Execute = new Jexl3Execute(params, this.constantParams);
        this.analyses.forEach(analysis -> analysis.execute(jexl3Execute));
        result.append(jexl3Execute.getResult());
        resultParams.addAll(jexl3Execute.getArgs());
        StringBuilder conditionResult = new StringBuilder();
        boolean appednSplicing = true;
        for (DynamicCondition dynamicCondition : this.dynamicConditions) {
            Jexl3Execute jexl3Execute_ = new Jexl3Execute(params, this.constantParams);
            this.conditionAnalysis.get(dynamicCondition).forEach(d -> d.execute(jexl3Execute_));
            String result_ = jexl3Execute_.getResult();
            if (!StringUtils.isNotBlank((CharSequence)result_)) continue;
            if (appednSplicing && dynamicCondition.appendDynamicSplicing() && StringUtils.isNotBlank((CharSequence)this.dynamic.splicing())) {
                conditionResult.append(" ").append(this.dynamic.splicing()).append(" ").append(result_.trim());
                appednSplicing = false;
            } else {
                conditionResult.append(" ").append(dynamicCondition.splicing()).append(" ");
                conditionResult.append(result_.trim());
            }
            resultParams.addAll(jexl3Execute_.getArgs());
        }
        result.append((CharSequence)conditionResult);
        return new DyanmicExecuteResult(this.dynamic.type(), result, resultParams);
    }
}

