/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.config;

import cn.zhangfusheng.elasticsearch.annotation.ElasticSearchConfig;
import cn.zhangfusheng.elasticsearch.thread.ThreadLocalDetail;
import cn.zhangfusheng.elasticsearch.transactional.TransactionalControl;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

public class ElasticSearchConfigOperationSourceAdvisor
extends AbstractPointcutAdvisor {
    private static final Class<ElasticSearchConfig> ELASTIC_SEARCH_CONFIG_CLASS = ElasticSearchConfig.class;
    private final RestHighLevelClient restHighLevelClient;

    public ElasticSearchConfigOperationSourceAdvisor(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public Pointcut getPointcut() {
        return new ElasticSearchConfigStaticMethodMatcherPointcut();
    }

    public Advice getAdvice() {
        return new ElasticSearchConfigMethodInterceptor();
    }

    class ElasticSearchConfigMethodInterceptor
    implements MethodInterceptor {
        ElasticSearchConfigMethodInterceptor() {
        }

        @Nullable
        public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
            Throwable throwable = null;
            ThreadLocalDetail threadLocalDetail = ThreadLocalDetail.start(invocation.getMethod().getAnnotation(ElasticSearchConfig.class));
            try {
                Object object = invocation.proceed();
                return object;
            }
            catch (Throwable e) {
                throwable = e;
                throw e;
            }
            finally {
                Optional<TransactionalControl> transactionalControlOptional = threadLocalDetail.transactionaControl();
                if (transactionalControlOptional.isPresent()) {
                    TransactionalControl transactionalControl = transactionalControlOptional.get();
                    transactionalControl.commit(throwable, ElasticSearchConfigOperationSourceAdvisor.this.restHighLevelClient);
                }
            }
        }
    }

    static class ElasticSearchConfigStaticMethodMatcherPointcut
    extends StaticMethodMatcherPointcut {
        ElasticSearchConfigStaticMethodMatcherPointcut() {
        }

        public boolean matches(Method method, Class<?> targetClass) {
            return Objects.nonNull(method.getAnnotation(ELASTIC_SEARCH_CONFIG_CLASS));
        }
    }
}

