/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.constant.enumeration.DyanmicType;
import cn.zhangfusheng.elasticsearch.dynamic.DyanmicExecuteResult;
import cn.zhangfusheng.elasticsearch.dynamic.DynamicAnalysis;
import cn.zhangfusheng.elasticsearch.dynamic.DynamicAnalysisDetail;
import cn.zhangfusheng.elasticsearch.dynamic.sql.es.ElasticSql2DslParser;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import com.alibaba.fastjson.JSON;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public interface TemplateDynamicStrApi
extends Template,
ElasticSearchTemplateApi {
    default public Object runDynamicStr(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index) {
        try {
            Class<? extends ElasticSearchRepository<?>> daoClass = entityRepositoryDetail.getElasticSearchRepositoryClass();
            DynamicAnalysisDetail dynamicAnalysisDetail = new DynamicAnalysis().analysis(daoClass, method);
            DyanmicExecuteResult dyanmicExecuteResult = dynamicAnalysisDetail.execute(args);
            DyanmicType type = dyanmicExecuteResult.getType();
            switch (type) {
                case SQL: {
                    return this.runDynamicSql(entityRepositoryDetail, method, args, routing, index, dyanmicExecuteResult);
                }
                case DSL: {
                    return this.runDynamicDsl(entityRepositoryDetail, method, args, routing, index, dyanmicExecuteResult);
                }
            }
            throw new GlobalSystemException("DyanmicType \u5339\u914d\u5931\u8d25");
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }

    default public Object runDynamicDsl(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index, DyanmicExecuteResult dyanmicExecuteResult) throws IOException {
        String str = JSON.parseObject((String)dyanmicExecuteResult.getStrResult()).toJSONString();
        log.debug("dyanmic result dsl:{}", (Object)ElasticSearchConstant.PATTERN.matcher(str).replaceAll(" "));
        String[] indices = this.analysisIndex(method, args, index);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.wrapperQuery((String)str)).trackTotalHitsUpTo(10000);
        SearchRequest searchRequest = new SearchRequest().routing(routing).indices(indices).source(searchSourceBuilder);
        Optional<PageRequest> pageRequestOptional = Arrays.stream(args).filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
        return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
    }

    default public Object runDynamicSql(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, String index, DyanmicExecuteResult execute) throws IOException {
        String str = execute.getStrResult();
        log.debug("dyanmic result sql:{}", (Object)ElasticSearchConstant.PATTERN.matcher(str).replaceAll(" "));
        ElasticSqlParseResult parseResult = new ElasticSql2DslParser().parse(str);
        SearchSourceBuilder searchSourceBuilder = parseResult.getSearchRequest().source();
        searchSourceBuilder.trackTotalHitsUpTo(10000);
        String[] indices = this.analysisIndex(method, args, index);
        SearchRequest searchRequest = parseResult.getSearchRequest().source(searchSourceBuilder).routing(routing).indices(indices);
        Optional<PageRequest> pageRequestOptional = Arrays.stream(args).filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
        return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
    }
}

