/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.page;

import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;

public class PageResponse<T> {
    private List<Object[]> searchAfter;
    private long total;
    private TotalHits.Relation relation;
    private List<T> data;

    public PageResponse(List<Object[]> searchAfter, long total, TotalHits.Relation relation, List<T> data) {
        this.searchAfter = searchAfter;
        this.total = total;
        this.relation = relation;
        this.data = data;
    }

    public PageResponse(List<Object[]> searchAfter, long total, List<T> data) {
        this.searchAfter = searchAfter;
        this.total = total;
        this.data = data;
    }

    public PageResponse(long total, List<T> data) {
        this.total = total;
        this.data = data;
    }

    public PageResponse<T> setTotal(TotalHits totalHits) {
        this.total = Objects.isNull(totalHits) ? 0L : totalHits.value;
        this.relation = totalHits.relation;
        return this;
    }

    public List<Object[]> getSearchAfter() {
        return this.searchAfter;
    }

    public long getTotal() {
        return this.total;
    }

    public TotalHits.Relation getRelation() {
        return this.relation;
    }

    public List<T> getData() {
        return this.data;
    }

    public PageResponse<T> setSearchAfter(List<Object[]> searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public PageResponse<T> setRelation(TotalHits.Relation relation) {
        this.relation = relation;
        return this;
    }

    public PageResponse<T> setData(List<T> data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResponse)) {
            return false;
        }
        PageResponse other = (PageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<Object[]> this$searchAfter = this.getSearchAfter();
        List<Object[]> other$searchAfter = other.getSearchAfter();
        if (this$searchAfter == null ? other$searchAfter != null : !((Object)this$searchAfter).equals(other$searchAfter)) {
            return false;
        }
        TotalHits.Relation this$relation = this.getRelation();
        TotalHits.Relation other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !this$relation.equals(other$relation)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<Object[]> $searchAfter = this.getSearchAfter();
        result = result * 59 + ($searchAfter == null ? 43 : ((Object)$searchAfter).hashCode());
        TotalHits.Relation $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResponse(searchAfter=" + this.getSearchAfter() + ", total=" + this.getTotal() + ", relation=" + this.getRelation() + ", data=" + this.getData() + ")";
    }

    public PageResponse() {
    }
}

