/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.page;

import java.util.Arrays;
import java.util.Objects;

public class PageRequest {
    public static final PageRequest DEFAULT = new PageRequest(0, 10);
    public static final PageRequest SEARCH_ONE = new PageRequest(0, 1);
    private Integer from = 1;
    private Integer size = 10;
    private Object[] searchAfter;

    public PageRequest(int from, int size) {
        this.from = from;
        this.size = size;
    }

    public Integer getFrom() {
        if (Objects.isNull(this.from)) {
            return null;
        }
        if (this.from <= 0) {
            return 0;
        }
        return (this.from - 1) * this.size;
    }

    public Integer getSize() {
        return this.size;
    }

    public Object[] getSearchAfter() {
        return this.searchAfter;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setSearchAfter(Object[] searchAfter) {
        this.searchAfter = searchAfter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageRequest)) {
            return false;
        }
        PageRequest other = (PageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        return Arrays.deepEquals(this.getSearchAfter(), other.getSearchAfter());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSearchAfter());
        return result;
    }

    public String toString() {
        return "PageRequest(from=" + this.getFrom() + ", size=" + this.getSize() + ", searchAfter=" + Arrays.deepToString(this.getSearchAfter()) + ")";
    }

    public PageRequest(Integer from, Integer size, Object[] searchAfter) {
        this.from = from;
        this.size = size;
        this.searchAfter = searchAfter;
    }

    public PageRequest() {
    }
}

