/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.es;

import cn.zhangfusheng.elasticsearch.constant.enumeration.RangeKeyword;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class EsRange {
    private RangeKeyword leftKeyword;
    private Object leftValue;
    private RangeKeyword rightKeyword;
    private Object rightValue;
    private String fromat;
    private Boolean includeLower;
    private Boolean includeUpper;

    public QueryBuilder builder(RangeQueryBuilder rangeQueryBuilder) {
        if (Objects.isNull(this.rightValue) || Objects.isNull(this.leftValue)) {
            throw new GlobalSystemException("left value or right value is null");
        }
        if (Objects.nonNull((Object)this.rightKeyword) && Objects.nonNull((Object)this.leftKeyword)) {
            this.rightKeyword.getBuilder(this.rightValue, rangeQueryBuilder);
            this.leftKeyword.getBuilder(this.leftValue, rangeQueryBuilder);
        } else {
            rangeQueryBuilder.from(this.leftValue).to(this.rightValue);
        }
        if (StringUtils.isNotBlank((CharSequence)this.fromat)) {
            rangeQueryBuilder.format(this.fromat);
        }
        if (Objects.nonNull(this.includeLower)) {
            rangeQueryBuilder.includeLower(this.includeLower.booleanValue());
        }
        if (Objects.nonNull(this.includeUpper)) {
            rangeQueryBuilder.includeUpper(this.includeUpper.booleanValue());
        }
        return rangeQueryBuilder;
    }

    public RangeKeyword getLeftKeyword() {
        return this.leftKeyword;
    }

    public Object getLeftValue() {
        return this.leftValue;
    }

    public RangeKeyword getRightKeyword() {
        return this.rightKeyword;
    }

    public Object getRightValue() {
        return this.rightValue;
    }

    public String getFromat() {
        return this.fromat;
    }

    public Boolean getIncludeLower() {
        return this.includeLower;
    }

    public Boolean getIncludeUpper() {
        return this.includeUpper;
    }

    public void setLeftKeyword(RangeKeyword leftKeyword) {
        this.leftKeyword = leftKeyword;
    }

    public void setLeftValue(Object leftValue) {
        this.leftValue = leftValue;
    }

    public void setRightKeyword(RangeKeyword rightKeyword) {
        this.rightKeyword = rightKeyword;
    }

    public void setRightValue(Object rightValue) {
        this.rightValue = rightValue;
    }

    public void setFromat(String fromat) {
        this.fromat = fromat;
    }

    public void setIncludeLower(Boolean includeLower) {
        this.includeLower = includeLower;
    }

    public void setIncludeUpper(Boolean includeUpper) {
        this.includeUpper = includeUpper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsRange)) {
            return false;
        }
        EsRange other = (EsRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$includeLower = this.getIncludeLower();
        Boolean other$includeLower = other.getIncludeLower();
        if (this$includeLower == null ? other$includeLower != null : !((Object)this$includeLower).equals(other$includeLower)) {
            return false;
        }
        Boolean this$includeUpper = this.getIncludeUpper();
        Boolean other$includeUpper = other.getIncludeUpper();
        if (this$includeUpper == null ? other$includeUpper != null : !((Object)this$includeUpper).equals(other$includeUpper)) {
            return false;
        }
        RangeKeyword this$leftKeyword = this.getLeftKeyword();
        RangeKeyword other$leftKeyword = other.getLeftKeyword();
        if (this$leftKeyword == null ? other$leftKeyword != null : !((Object)((Object)this$leftKeyword)).equals((Object)other$leftKeyword)) {
            return false;
        }
        Object this$leftValue = this.getLeftValue();
        Object other$leftValue = other.getLeftValue();
        if (this$leftValue == null ? other$leftValue != null : !this$leftValue.equals(other$leftValue)) {
            return false;
        }
        RangeKeyword this$rightKeyword = this.getRightKeyword();
        RangeKeyword other$rightKeyword = other.getRightKeyword();
        if (this$rightKeyword == null ? other$rightKeyword != null : !((Object)((Object)this$rightKeyword)).equals((Object)other$rightKeyword)) {
            return false;
        }
        Object this$rightValue = this.getRightValue();
        Object other$rightValue = other.getRightValue();
        if (this$rightValue == null ? other$rightValue != null : !this$rightValue.equals(other$rightValue)) {
            return false;
        }
        String this$fromat = this.getFromat();
        String other$fromat = other.getFromat();
        return !(this$fromat == null ? other$fromat != null : !this$fromat.equals(other$fromat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EsRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeLower = this.getIncludeLower();
        result = result * 59 + ($includeLower == null ? 43 : ((Object)$includeLower).hashCode());
        Boolean $includeUpper = this.getIncludeUpper();
        result = result * 59 + ($includeUpper == null ? 43 : ((Object)$includeUpper).hashCode());
        RangeKeyword $leftKeyword = this.getLeftKeyword();
        result = result * 59 + ($leftKeyword == null ? 43 : ((Object)((Object)$leftKeyword)).hashCode());
        Object $leftValue = this.getLeftValue();
        result = result * 59 + ($leftValue == null ? 43 : $leftValue.hashCode());
        RangeKeyword $rightKeyword = this.getRightKeyword();
        result = result * 59 + ($rightKeyword == null ? 43 : ((Object)((Object)$rightKeyword)).hashCode());
        Object $rightValue = this.getRightValue();
        result = result * 59 + ($rightValue == null ? 43 : $rightValue.hashCode());
        String $fromat = this.getFromat();
        result = result * 59 + ($fromat == null ? 43 : $fromat.hashCode());
        return result;
    }

    public String toString() {
        return "EsRange(leftKeyword=" + (Object)((Object)this.getLeftKeyword()) + ", leftValue=" + this.getLeftValue() + ", rightKeyword=" + (Object)((Object)this.getRightKeyword()) + ", rightValue=" + this.getRightValue() + ", fromat=" + this.getFromat() + ", includeLower=" + this.getIncludeLower() + ", includeUpper=" + this.getIncludeUpper() + ")";
    }

    public EsRange(RangeKeyword leftKeyword, Object leftValue, RangeKeyword rightKeyword, Object rightValue, String fromat, Boolean includeLower, Boolean includeUpper) {
        this.leftKeyword = leftKeyword;
        this.leftValue = leftValue;
        this.rightKeyword = rightKeyword;
        this.rightValue = rightValue;
        this.fromat = fromat;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }
}

