/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.jexl;

import cn.zhangfusheng.elasticsearch.jexl.Jexl3Constant;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.math.NumberUtils;

public class Jexl3Util {
    public static String toStr(String str) {
        StringBuilder result = new StringBuilder(str.length() * 2);
        Matcher mapMatcher = Jexl3Constant.MAP_PATTERN.matcher(str);
        int index = 0;
        while (mapMatcher.find()) {
            result.append(str, index, mapMatcher.start());
            String t = mapMatcher.group(1);
            if (!NumberUtils.isDigits((String)t)) {
                result.append("['").append(mapMatcher.group(1)).append("']");
            } else {
                result.append(mapMatcher.group(0));
            }
            index = mapMatcher.end();
        }
        if (result.length() != 0) {
            str = result.toString();
            result.setLength(0);
        }
        index = 0;
        Matcher matcher = Jexl3Constant.PREFIX_PATTERN.matcher(str);
        while (matcher.find()) {
            result.append(str, index, matcher.start());
            String prefix = matcher.group(1);
            String name = matcher.group(2);
            if (":".equals(prefix)) {
                boolean isDigits = NumberUtils.isDigits((String)name);
                if (isDigits) {
                    name = ':' + name;
                }
                result.append(Jexl3Constant.VAR_PREFIX).append("['").append(name).append("']");
            } else if ("$".equals(prefix)) {
                result.append(Jexl3Constant.CONST_PREFIX).append("['").append(name).append("']");
            }
            index = matcher.end(2);
        }
        result.append(str.substring(index));
        return result.toString();
    }

    public static Collection<?> asCollection(Object obj) {
        if (obj == null) {
            return Collections.EMPTY_SET;
        }
        if (obj.getClass().isArray()) {
            return Arrays.stream(Jexl3Util.asArray(obj)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.singletonList(obj);
    }

    public static Object[] asArray(Object obj) {
        if (obj == null) {
            return new Object[0];
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                Object[] array = new Object[length];
                for (int index = 0; index < length; ++index) {
                    array[index] = Array.get(obj, index);
                }
                return array;
            }
            return (Object[])obj;
        }
        return new Object[]{obj};
    }

    public static Object execute(Map<String, Object> params, Map<String, Object> constantParams, String scriptText) {
        JexlEngine jexlEngine = new JexlBuilder().create();
        JexlScript jexlScript = jexlEngine.createScript(scriptText);
        MapContext jexlContext = new MapContext();
        jexlContext.set(Jexl3Constant.VAR_PREFIX, params);
        jexlContext.set(Jexl3Constant.CONST_PREFIX, constantParams);
        return jexlScript.execute((JexlContext)jexlContext);
    }
}

