/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.constant.enumeration;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.es.EsRange;
import cn.zhangfusheng.elasticsearch.model.es.GeoDistance;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public enum SearchKeyword {
    MATCH_ALL("matchAll", (k, v) -> QueryBuilders.matchAllQuery()),
    MATCH("match", QueryBuilders::matchQuery),
    MULTI_MATCH("multiMatch", (k, v) -> QueryBuilders.multiMatchQuery((Object)k, (String[])new String[]{String.valueOf(v)})),
    MATCH_PHRASE("matchPhrase", QueryBuilders::matchPhraseQuery),
    MATCH_PHRASE_PREFIX("matchPhrasePrefix", QueryBuilders::matchPhrasePrefixQuery),
    TERM("term", QueryBuilders::termQuery),
    FUZZY("fuzzy", QueryBuilders::fuzzyQuery),
    PREFIX("prefix", (k, v) -> QueryBuilders.prefixQuery((String)k, (String)String.valueOf(v))),
    RANGE("range", (k, v) -> {
        if (v instanceof EsRange) {
            return ((EsRange)v).builder(QueryBuilders.rangeQuery((String)k));
        }
        throw new GlobalSystemException("range query params muster instanceof {}", EsRange.class.getName());
    }),
    WILDCARD("wildcard", (k, v) -> QueryBuilders.wildcardQuery((String)k, (String)String.valueOf(v))),
    REGEXP("regexp", (k, v) -> QueryBuilders.regexpQuery((String)k, (String)String.valueOf(v))),
    SPAN_TERM("spanTerm", (k, v) -> QueryBuilders.spanTermQuery((String)k, (String)String.valueOf(v))),
    TERMS("terms", (k, v) -> {
        if (v instanceof Collection) {
            return QueryBuilders.termsQuery((String)k, (Collection)((Collection)v));
        }
        throw new GlobalSystemException("terms value master instanceof Collection");
    }),
    GEO_DISTANCE("geoDistance", (k, v) -> {
        if (v instanceof GeoDistance) {
            GeoDistance geoDistance = (GeoDistance)v;
            if (StringUtils.isBlank((CharSequence)geoDistance.getDistance())) {
                return null;
            }
            return QueryBuilders.geoDistanceQuery((String)k).point(geoDistance.getLat(), geoDistance.getLon()).distance(geoDistance.getDistance(), geoDistance.getUnit()).geoDistance(geoDistance.getGeoDistance());
        }
        throw new GlobalSystemException("geoDistanceQuery value master instanceof {}", GeoDistance.class.getName());
    }),
    GEO_BOUNDING_BOX("geoBoundingBox", (k, v) -> QueryBuilders.geoBoundingBoxQuery((String)k)),
    EXISTS("exists", (k, v) -> QueryBuilders.existsQuery((String)k));

    private final String keyword;
    private final Builder builder;

    private SearchKeyword(String keyword, Builder builder) {
        this.keyword = keyword;
        this.builder = builder;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public QueryBuilder getBuilder(String key, Object value) {
        return this.builder.builder(key, value);
    }

    @FunctionalInterface
    static interface Builder {
        public QueryBuilder builder(String var1, Object var2);
    }
}

