package cn.zhangfusheng.elasticsearch.util;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author fusheng.zhang
 * @date 2022-05-11 19:52:15
 */
public class MapUtil {

    private static final Map<Class<?>, Field[]> FIELD_CACHE = new HashMap<>();

    public static List<Object> entityToList(Collection<?> collection) {
        return collection.stream()
                .map(o -> Objects.isNull(o.getClass().getClassLoader()) ? o : MapUtil.entityToMap(o))
                .collect(Collectors.toList());
    }

    public static Map<String, Object> entityToMap(Object o) {
        boolean isNull = Objects.isNull(o);
        Class<?> aClass = o.getClass();
        if (!FIELD_CACHE.containsKey(aClass)) {
            FIELD_CACHE.put(aClass, aClass.getDeclaredFields());
        }
        Field[] declaredFields = FIELD_CACHE.get(aClass);
        Map<String, Object> result = new HashMap<>(declaredFields.length);
        try {
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(Boolean.TRUE);
                result.put(declaredField.getName(), isNull ? null : declaredField.get(o));
                declaredField.setAccessible(Boolean.FALSE);
            }
            return result;
        } catch (IllegalAccessException e) {
            throw new GlobalSystemException(e);
        }
    }
}
