package cn.zhangfusheng.elasticsearch.template;

import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RestHighLevelClient;

/**
 * @author fusheng.zhang
 * @date 2022-02-24 15:50:33
 */
public abstract class AbstractElasticSearchRestTemplate
        implements Template, TemplageIngestApi, TemplateDocumentApi,
        TemplateSearchApi, TemplateJpaApi, TemplateMybatisApi, TemplateDynamicStrApi, TemplateDynamicSqlApi {

    private final RestHighLevelClient restHighLevelClient;
    private final IndicesClient indicesClient;

    protected AbstractElasticSearchRestTemplate(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
        this.indicesClient = restHighLevelClient.indices();
    }


    @Override
    public RestHighLevelClient restHighLevelClient() {
        return restHighLevelClient;
    }

    @Override
    public IndicesClient indicesClient() {
        return indicesClient;
    }

}
