package cn.zhangfusheng.elasticsearch.config;

import cn.zhangfusheng.elasticsearch.annotation.EnablePaodingRoseElasticSearch;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

/**
 * @author fusheng.zhang
 * @date 2022-04-20 12:18:35
 */
public class ElasticSearchConfigConfiguration implements ImportAware, BeanFactoryAware {

    private BeanFactory beanFactory;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes.fromMap(
                importMetadata.getAnnotationAttributes(EnablePaodingRoseElasticSearch.class.getName()));
    }

    @Bean
    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    public ElasticSearchConfigOperationSourceAdvisor beanFactoryTransactionalOperationSourceAdvisor() {
        RestHighLevelClient restHighLevelClient = beanFactory.getBean(RestHighLevelClient.class);
        return new ElasticSearchConfigOperationSourceAdvisor(restHighLevelClient);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}
