/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.annotation.dsl.mybatis.DslWithMybatis;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface TemplateMybatisApi
extends Template,
ElasticSearchTemplateApi {
    public static final Logger log = LoggerFactory.getLogger(TemplateMybatisApi.class);

    default public Object runIbatis(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, Map<String, Object> params, String routing, DslWithMybatis dslWithMybatis, Configuration configuration, String index) {
        try {
            String nameSpace = String.format("%s.%s", dslWithMybatis.nameSpace(), dslWithMybatis.id());
            MappedStatement mappedStatement = configuration.getMappedStatement(nameSpace);
            BoundSql boundSql = mappedStatement.getBoundSql(params);
            params.forEach((arg_0, arg_1) -> ((BoundSql)boundSql).setAdditionalParameter(arg_0, arg_1));
            String sql = boundSql.getSql();
            sql = ElasticSearchConstant.PATTERN.matcher(sql).replaceAll(" ");
            log.debug("dynamic dsl:{}", (Object)sql);
            for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                Object value;
                String property = parameterMapping.getProperty();
                Object object = value = boundSql.hasAdditionalParameter(property) ? boundSql.getAdditionalParameter(property) : configuration.newMetaObject(params.get(property)).getValue(property);
                if (sql.charAt(sql.indexOf("?") - 1) != '\"' && value instanceof String) {
                    value = String.format("\"%s\"", value);
                }
                if (value instanceof Collection) {
                    value = String.format("[\"%s\"]", String.join((CharSequence)"\",\"", (Collection)value));
                }
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(String.valueOf(value)));
            }
            String[] indices = this.analysisIndex(method, args, index);
            SearchRequest searchRequest = new SearchRequest().routing(routing).indices(indices).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.wrapperQuery((String)sql)));
            log.debug("result dsl:{}", (Object)sql);
            Optional<PageRequest> pageRequestOptional = params.values().stream().filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
            return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
    }
}

