/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.annotation.dsl.jpa.JpaSearch;
import cn.zhangfusheng.elasticsearch.annotation.dsl.jpa.JpaSearchs;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.constant.enumeration.SearchKeyword;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.jpa.JpaBetween;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public interface TemplateJpaApi
extends Template,
ElasticSearchTemplateApi {
    default public Object runJpa(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, Object[] args, String routing, Class<?> entityClass, String index) {
        try {
            this.analysisJapSearchAnnotation(method);
            List<Object> params = Arrays.stream(args).collect(Collectors.toList());
            BoolQueryBuilder boolQueryBuilder = this.buildBoolQueryWithJap(method, null, params, entityClass);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder);
            String[] indices = this.analysisIndex(method, args, index);
            SearchRequest searchRequest = new SearchRequest().routing(routing).indices(indices).source(searchSourceBuilder);
            Optional<PageRequest> pageRequestOptional = params.stream().filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
            return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void analysisJapSearchAnnotation(Method method) {
        if (!ElasticSearchConstant.JPA_SEARCH_CACHE.containsKey(method)) {
            Map<Method, Map<String, SearchKeyword>> map = ElasticSearchConstant.JPA_SEARCH_CACHE;
            synchronized (map) {
                if (!ElasticSearchConstant.JPA_SEARCH_CACHE.containsKey(method)) {
                    JpaSearchs jpaSearchs = method.getAnnotation(JpaSearchs.class);
                    JpaSearch jpaSearch = method.getAnnotation(JpaSearch.class);
                    ArrayList<JpaSearch> jpaSearchList = new ArrayList<JpaSearch>();
                    if (Objects.nonNull(jpaSearchs) || Objects.nonNull(jpaSearch)) {
                        if (Objects.nonNull(jpaSearchs) && jpaSearchs.value().length > 0) {
                            jpaSearchList.addAll(Arrays.asList(jpaSearchs.value()));
                        }
                        if (Objects.nonNull(jpaSearch)) {
                            jpaSearchList.add(jpaSearch);
                        }
                        Map<String, SearchKeyword> jpaSearchConfig = jpaSearchList.stream().collect(Collectors.toMap(JpaSearch::value, JpaSearch::searchKeyword));
                        ElasticSearchConstant.JPA_SEARCH_CACHE.put(method, jpaSearchConfig);
                    }
                }
            }
        }
    }

    default public BoolQueryBuilder buildBoolQueryWithJap(Method method, BoolQueryBuilder base, List<Object> args, Class<?> entityClass) {
        Iterator<Object> argsIterator = args.iterator();
        PartTree tree = new PartTree(method.getName(), entityClass);
        BoolQueryBuilder pre = null;
        for (PartTree.OrPart node : tree) {
            BoolQueryBuilder boolQueryBuilder;
            Iterator parts = node.iterator();
            if (!parts.hasNext()) continue;
            Part part = (Part)parts.next();
            if (!argsIterator.hasNext()) continue;
            BoolQueryBuilder current = this.create(method, part, argsIterator.next());
            while (parts.hasNext()) {
                part = (Part)parts.next();
                if (!argsIterator.hasNext()) continue;
                current = this.and(method, part, current, argsIterator.next());
            }
            if (base == null) {
                boolQueryBuilder = current;
            } else {
                BoolQueryBuilder boolQueryBuilder2 = base == pre ? QueryBuilders.boolQuery().should((QueryBuilder)pre) : base;
                pre = current;
                boolQueryBuilder = this.or(boolQueryBuilder2, pre);
            }
            base = boolQueryBuilder;
        }
        return base;
    }

    default public BoolQueryBuilder create(Method method, Part part, Object value) {
        return this.from(method, part, QueryBuilders.boolQuery(), value);
    }

    default public BoolQueryBuilder and(Method method, Part part, BoolQueryBuilder base, Object value) {
        return this.from(method, part, base, value);
    }

    default public BoolQueryBuilder or(BoolQueryBuilder base, BoolQueryBuilder query) {
        return base.should((QueryBuilder)query);
    }

    default public BoolQueryBuilder from(Method method, Part part, BoolQueryBuilder boolQueryBuilder, Object parameter) {
        String key = part.getProperty().getSegment();
        Map<String, SearchKeyword> jpaSearchConfig = ElasticSearchConstant.JPA_SEARCH_CACHE.get(method);
        if (Objects.nonNull(jpaSearchConfig) && jpaSearchConfig.containsKey(key)) {
            SearchKeyword searchKeyword = jpaSearchConfig.get(key);
            return boolQueryBuilder.must(searchKeyword.getBuilder(key, parameter));
        }
        Part.Type type = part.getType();
        switch (type) {
            case TRUE: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)Boolean.TRUE));
            }
            case FALSE: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)Boolean.FALSE));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)parameter));
            }
            case LIKE: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)parameter));
            }
            case SIMPLE_PROPERTY: 
            case REGEX: 
            case STARTING_WITH: 
            case ENDING_WITH: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)parameter));
            }
            case CONTAINING: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)key, (Object)parameter));
            }
            case GREATER_THAN: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gt(parameter));
            }
            case AFTER: 
            case GREATER_THAN_EQUAL: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).gte(parameter));
            }
            case LESS_THAN: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).lt(parameter));
            }
            case BEFORE: 
            case LESS_THAN_EQUAL: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)key).lte(parameter));
            }
            case BETWEEN: {
                if (!(parameter instanceof JpaBetween)) {
                    throw new GlobalSystemException("\u4f7f\u7528 between\u65f6,\u4e0e\u4e4b\u5bf9\u5e94\u7684\u53c2\u6570\u5fc5\u987b\u662f JpaBwtween ");
                }
                JpaBetween jpaBetween = (JpaBetween)parameter;
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)key);
                if (Objects.nonNull(jpaBetween.getGt())) {
                    rangeQueryBuilder.gt(jpaBetween.getGt());
                }
                if (Objects.nonNull(jpaBetween.getLte())) {
                    rangeQueryBuilder.lte(jpaBetween.getLte());
                }
                return boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            }
            case IS_NULL: {
                return boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)key));
            }
            case IS_NOT_NULL: {
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)key));
            }
            case IN: {
                if (!(parameter instanceof Collection)) {
                    throw new GlobalSystemException("in params not instanceof Collection");
                }
                return boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (Collection)((Collection)parameter)));
            }
            case NOT_IN: {
                if (!(parameter instanceof Collection)) {
                    throw new GlobalSystemException("not in params not instanceof Collection");
                }
                return boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)key, (Collection)((Collection)parameter)));
            }
        }
        throw new RuntimeException("Illegal criteria found '" + type + "'.");
    }

    default public void buildSearch() {
    }
}

