/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.annotation.dsl.DslIndex;
import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.Template;
import cn.zhangfusheng.elasticsearch.thread.ThreadLocalDetail;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public interface ElasticSearchTemplateApi
extends Template {
    public static final Logger log = LoggerFactory.getLogger(ElasticSearchTemplateApi.class);

    default public Object search(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Method method, SearchRequest searchRequest, PageRequest pageRequest) throws IOException {
        ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
        Consumer<SearchHit[]> consumer = hs -> searchHits.addAll(Arrays.asList(hs));
        SearchResponse searchResponse = Objects.nonNull(pageRequest) ? this.searchWithPage(searchRequest, pageRequest, consumer) : this.search(searchRequest, consumer);
        return entityRepositoryDetail.analysisSearchResponse(searchResponse, searchHits, method);
    }

    default public SearchResponse search(SearchRequest searchRequest, Consumer<SearchHit[]> consumer) throws IOException {
        CountRequest countRequest;
        boolean trackTotalHits = ThreadLocalDetail.trackTotalHits();
        long totalNum = ElasticSearchConstant.MAX_DOC_SIZE.longValue();
        if (trackTotalHits && (totalNum = this.count(countRequest = new CountRequest(searchRequest.indices(), searchRequest.source()).routing(searchRequest.routing()))) > (long)ElasticSearchConstant.MAX_DOC_SIZE.intValue()) {
            Integer scrollSize = ThreadLocalDetail.scrollSize().orElse(ElasticSearchConstant.THRESHOLD_DOC_SIZE);
            searchRequest.source().size(scrollSize.intValue());
            return this.searchWitchScroll(searchRequest, consumer, -1, null);
        }
        SearchResponse searchResponse = null;
        searchRequest.source().size(Long.valueOf(totalNum).intValue());
        log.debug("index:{},routing:{},queryJson:{}", new Object[]{searchRequest.indices(), searchRequest.routing(), searchRequest.source()});
        if (totalNum > (long)(ElasticSearchConstant.THRESHOLD_DOC_SIZE * 2)) {
            searchRequest.source().size(ElasticSearchConstant.THRESHOLD_DOC_SIZE.intValue());
            long loopNum = totalNum % (long)ElasticSearchConstant.THRESHOLD_DOC_SIZE.intValue() == 0L ? (long)ElasticSearchConstant.DEFAULT_LOOP_PAGE_NUM.intValue() : totalNum / (long)ElasticSearchConstant.THRESHOLD_DOC_SIZE.intValue() + 1L;
            int i = 0;
            while ((long)i < loopNum) {
                searchRequest.source().from(i * ElasticSearchConstant.THRESHOLD_DOC_SIZE);
                log.debug("index:{},routing:{},queryJson:{}", new Object[]{searchRequest.indices(), searchRequest.routing(), searchRequest.source()});
                searchResponse = this.restHighLevelClient().search(searchRequest, RequestOptions.DEFAULT);
                SearchHit[] hits = searchResponse.getHits().getHits();
                if (!Objects.nonNull(hits) || hits.length <= 0) break;
                consumer.accept(hits);
                if (hits.length >= ElasticSearchConstant.THRESHOLD_DOC_SIZE) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            searchResponse = this.restHighLevelClient().search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (Objects.nonNull(hits) && hits.length > 0) {
                consumer.accept(hits);
            }
        }
        return searchResponse;
    }

    default public SearchResponse searchWithPage(SearchRequest searchRequest, PageRequest pageRequest, Consumer<SearchHit[]> consumer) {
        try {
            boolean trackTotalHits;
            searchRequest.source().size(pageRequest.getSize().intValue());
            if (pageRequest.getFrom() + pageRequest.getSize() > ElasticSearchConstant.MAX_DOC_SIZE && (Objects.isNull(pageRequest.getSearchAfter()) || pageRequest.getSearchAfter().length <= 0)) {
                throw new GlobalSystemException("\u8d85\u51fa\u6700\u5927\u67e5\u8be2\u6570\u636e\u9650\u5236,\u5fc5\u987b\u8bbe\u7f6esearchAfter\u53c2\u6570");
            }
            if (Objects.nonNull(pageRequest.getSearchAfter()) && pageRequest.getSearchAfter().length > 0) {
                searchRequest.source().searchAfter(pageRequest.getSearchAfter());
            } else {
                searchRequest.source().from(pageRequest.getFrom().intValue());
            }
            if (CollectionUtils.isEmpty((Collection)searchRequest.source().sorts())) {
                searchRequest.source().sort("_id", SortOrder.DESC);
            }
            if (trackTotalHits = ThreadLocalDetail.trackTotalHits()) {
                searchRequest.source().trackTotalHits(Boolean.TRUE.booleanValue());
            }
            log.debug("index:{},routing:{},queryJson:{}", new Object[]{searchRequest.indices(), searchRequest.routing(), searchRequest.source()});
            SearchResponse searchResponse = this.restHighLevelClient().search(searchRequest, RequestOptions.DEFAULT);
            consumer.accept(searchResponse.getHits().getHits());
            return searchResponse;
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    default public SearchResponse searchWitchScroll(SearchRequest searchRequest, Consumer<SearchHit[]> consumer, int runNum, String scrollId) {
        SearchResponse searchResponse = null;
        try {
            Long keepAlive = ThreadLocalDetail.keepAlive().orElse(5000L);
            TimeValue timeValue = TimeValue.timeValueMillis((long)keepAlive);
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            if (StringUtils.isBlank((CharSequence)scrollId)) {
                searchRequest.scroll(timeValue);
                log.debug("index:{},routing:{},queryJson:{}", new Object[]{searchRequest.indices(), searchRequest.routing(), searchRequest.source()});
                searchResponse = this.restHighLevelClient().search(searchRequest, RequestOptions.DEFAULT);
            } else {
                log.debug("index:{},routing:{},searchScrollId:{}", new Object[]{searchRequest.indices(), searchRequest.routing(), scrollRequest.getDescription()});
                searchResponse = this.restHighLevelClient().scroll(scrollRequest, RequestOptions.DEFAULT);
            }
            SearchHit[] hits = searchResponse.getHits().getHits();
            int num = 1;
            while (hits != null && hits.length > 0) {
                consumer.accept(hits);
                if (Objects.isNull(searchResponse.getScrollId())) break;
                if (num++ == runNum) {
                    break;
                }
                scrollRequest.scrollId(searchResponse.getScrollId()).scroll(timeValue);
                log.debug("searchScrollId:{}", (Object)scrollRequest.getDescription());
                searchResponse = this.restHighLevelClient().scroll(scrollRequest, RequestOptions.DEFAULT);
                hits = searchResponse.getHits().getHits();
            }
        }
        catch (Exception e) {
            throw new GlobalSystemException(e);
        }
        finally {
            if (Objects.nonNull(searchResponse)) {
                this.clearScroll(searchResponse.getScrollId());
            }
        }
        return searchResponse;
    }

    default public void clearScroll(String scrollId) {
        if (StringUtils.isNotBlank((CharSequence)scrollId)) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            try {
                ClearScrollResponse clearScrollResponse = this.restHighLevelClient().clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                log.debug("clear scroll:{} success?{}", (Object)scrollId, (Object)clearScrollResponse.isSucceeded());
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    default public long count(CountRequest countRequest) {
        try {
            CountResponse countResponse = this.restHighLevelClient().count(countRequest, RequestOptions.DEFAULT);
            return countResponse.getCount();
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String[] analysisIndex(Method method, Object[] args, String index) {
        if (ElasticSearchConstant.METHOD_INDEX_CACHE.containsKey(method)) {
            return ElasticSearchConstant.METHOD_INDEX_CACHE.get(method);
        }
        Map<Method, String[]> map = ElasticSearchConstant.METHOD_INDEX_CACHE;
        synchronized (map) {
            DslIndex dslIndex;
            if (ElasticSearchConstant.METHOD_INDEX_CACHE.containsKey(method)) {
                return ElasticSearchConstant.METHOD_INDEX_CACHE.get(method);
            }
            ArrayList<String> indices = new ArrayList<String>(args.length + 1);
            if (Objects.nonNull(method) && Objects.nonNull(dslIndex = method.getAnnotation(DslIndex.class))) {
                this.analysisIndex(dslIndex, indices);
            }
            if (CollectionUtils.isEmpty(indices)) {
                indices.add(index);
            }
            ElasticSearchConstant.METHOD_INDEX_CACHE.put(method, (String[])indices.stream().distinct().toArray(String[]::new));
        }
        return ElasticSearchConstant.METHOD_INDEX_CACHE.get(method);
    }

    default public void analysisIndex(DslIndex dslIndex, List<String> indices) {
        Class<?>[] value;
        for (Class<?> indexClass : value = dslIndex.value()) {
            if (indexClass.equals(Void.class)) continue;
            if (!ElasticSearchConstant.REPOSITORY_DETAIL_CACHE.containsKey(indexClass)) {
                throw new GlobalSystemException("\u6839\u636e{},\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7d22\u5f15", indexClass.getName());
            }
            indices.add(ElasticSearchConstant.REPOSITORY_DETAIL_CACHE.get(indexClass).getIndexName());
        }
    }

    default public String[] analysisIndex(Object[] args, String ... index) {
        if (Objects.isNull(args)) {
            return index;
        }
        ArrayList<String> indices = new ArrayList<String>(args.length);
        for (Object arg : args) {
            DslIndex dslIndex = arg.getClass().getAnnotation(DslIndex.class);
            if (!Objects.nonNull(dslIndex)) continue;
            this.analysisIndex(dslIndex, indices);
        }
        if (CollectionUtils.isEmpty(indices)) {
            return index;
        }
        return (String[])indices.stream().distinct().toArray(String[]::new);
    }
}

