/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.register;

import cn.zhangfusheng.elasticsearch.annotation.EnablePaodingRoseElasticSearch;
import cn.zhangfusheng.elasticsearch.annotation.document.IndexDiscription;
import cn.zhangfusheng.elasticsearch.cycle.CreateMappingBefore;
import cn.zhangfusheng.elasticsearch.cycle.CreateMappingEnd;
import cn.zhangfusheng.elasticsearch.factory.ElasticSearchRepositoryFactoryBean;
import cn.zhangfusheng.elasticsearch.mybatis.ElasticSearchWithMybatisXmlConfig;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryFilter;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchRepositoryScanner;
import cn.zhangfusheng.elasticsearch.transfer.TransferInfo;
import cn.zhangfusheng.elasticsearch.transfer.TransferInfoRepository;
import cn.zhangfusheng.elasticsearch.util.date.LocalDateTimeUtils;
import cn.zhangfusheng.elasticsearch.util.date.enumeration.DateFromatEnum;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class PaodingRoseElasticSearchRegister
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(PaodingRoseElasticSearchRegister.class);
    private AdviceMode adviceMode;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnablePaodingRoseElasticSearch.class.getName());
        if (Objects.isNull(annotationAttributes)) {
            return;
        }
        this.adviceMode = (AdviceMode)annotationAttributes.get("mode");
        String packageName = ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
        HashSet<String> scanReposityPackages = new HashSet<String>();
        HashSet<String> mybatisXmlScanPath = new HashSet<String>();
        if (annotationAttributes.containsKey("scanReposityPackages")) {
            String[] basePackage = (String[])annotationAttributes.get("scanReposityPackages");
            scanReposityPackages.addAll(Arrays.stream(basePackage).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        if (annotationAttributes.containsKey("mybatisXmlScanPath")) {
            String[] basePath = (String[])annotationAttributes.get("mybatisXmlScanPath");
            mybatisXmlScanPath.addAll(Arrays.stream(basePath).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        if (scanReposityPackages.isEmpty()) {
            scanReposityPackages.add(packageName);
        }
        ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig = new ElasticSearchWithMybatisXmlConfig(mybatisXmlScanPath);
        this.scanReposityAndRegister(registry, scanReposityPackages, elasticSearchWithMybatisXmlConfig);
        this.registerTransferInfoBeanDefinition(registry, elasticSearchWithMybatisXmlConfig);
    }

    private void scanReposityAndRegister(BeanDefinitionRegistry registry, Set<String> scanReposityPackages, Configuration elasticSearchWithMybatisXmlConfig) {
        ElasticSearchRepositoryScanner scanner = new ElasticSearchRepositoryScanner(registry);
        ElasticSearchEntityRepositoryFilter filter = new ElasticSearchEntityRepositoryFilter(ElasticSearchRepository.class);
        scanner.addIncludeFilter((TypeFilter)filter);
        scanner.doScan(scanReposityPackages.toArray(new String[0]));
        filter.getEntityRepositoryDetails().forEach(entityRepositoryDetail -> this.registerRepositoryBeanDefinition(registry, (ElasticSearchEntityRepositoryDetail)entityRepositoryDetail, elasticSearchWithMybatisXmlConfig));
    }

    private void registerRepositoryBeanDefinition(BeanDefinitionRegistry registry, ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Configuration elasticSearchWithMybatisXmlConfig) {
        log.debug("register zingRepository with:{}", (Object)entityRepositoryDetail.getEntityClass().getName());
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(ElasticSearchRepositoryFactoryBean.class).addPropertyValue("entityRepositoryDetail", (Object)entityRepositoryDetail).addPropertyValue("beanFactory", (Object)this.beanFactory).addPropertyValue("adviceMode", (Object)this.adviceMode).addPropertyValue("objectType", entityRepositoryDetail.getElasticSearchRepositoryClass()).addPropertyValue("elasticSearchWithMybatisXmlConfig", (Object)elasticSearchWithMybatisXmlConfig).setLazyInit(Boolean.FALSE.booleanValue()).getBeanDefinition();
        registry.registerBeanDefinition(entityRepositoryDetail.getRepositoryBeanName(), (BeanDefinition)beanDefinition);
    }

    private void registerTransferInfoBeanDefinition(BeanDefinitionRegistry registry, ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig) {
        Class<TransferInfo> entityClass = TransferInfo.class;
        IndexDiscription indexDiscription = new IndexDiscription(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return IndexDiscription.class;
            }

            @Override
            public String value() {
                return "transfer";
            }

            @Override
            public int version() {
                return 1;
            }

            @Override
            public String upgradeVersion() {
                return LocalDateTimeUtils.nowTime(DateFromatEnum.YYYY_MM_DD_HH_MM_SS);
            }

            @Override
            public Class<? extends CreateMappingBefore>[] createMappingBefore() {
                return null;
            }

            @Override
            public Class<? extends CreateMappingEnd>[] createMappingEnd() {
                return null;
            }
        };
        ElasticSearchEntityRepositoryDetail elasticSearchEntityRepositoryDetail = new ElasticSearchEntityRepositoryDetail(false, TransferInfoRepository.class, entityClass, indexDiscription, null);
        this.registerRepositoryBeanDefinition(registry, elasticSearchEntityRepositoryDetail, elasticSearchWithMybatisXmlConfig);
    }
}

