/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.es;

import org.elasticsearch.common.unit.DistanceUnit;

public class GeoDistance {
    private double lat;
    private double lon;
    private String distance;
    private DistanceUnit unit = DistanceUnit.METERS;
    private org.elasticsearch.common.geo.GeoDistance geoDistance = org.elasticsearch.common.geo.GeoDistance.ARC;

    public GeoDistance(double lat, double lon, String distance) {
        this.lat = lat;
        this.lon = lon;
        this.distance = distance;
    }

    public GeoDistance(String location, String distance) {
        String[] latLon = location.split(",");
        this.lat = Double.parseDouble(latLon[0]);
        this.lon = Double.parseDouble(latLon[1]);
        this.distance = distance;
    }

    public GeoDistance(String location) {
        String[] latLon = location.split(",");
        this.lat = Double.parseDouble(latLon[0]);
        this.lon = Double.parseDouble(latLon[1]);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public String getDistance() {
        return this.distance;
    }

    public DistanceUnit getUnit() {
        return this.unit;
    }

    public org.elasticsearch.common.geo.GeoDistance getGeoDistance() {
        return this.geoDistance;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public void setUnit(DistanceUnit unit) {
        this.unit = unit;
    }

    public void setGeoDistance(org.elasticsearch.common.geo.GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoDistance)) {
            return false;
        }
        GeoDistance other = (GeoDistance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLat(), other.getLat()) != 0) {
            return false;
        }
        if (Double.compare(this.getLon(), other.getLon()) != 0) {
            return false;
        }
        String this$distance = this.getDistance();
        String other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !this$distance.equals(other$distance)) {
            return false;
        }
        DistanceUnit this$unit = this.getUnit();
        DistanceUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        org.elasticsearch.common.geo.GeoDistance this$geoDistance = this.getGeoDistance();
        org.elasticsearch.common.geo.GeoDistance other$geoDistance = other.getGeoDistance();
        return !(this$geoDistance == null ? other$geoDistance != null : !this$geoDistance.equals(other$geoDistance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoDistance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lat = Double.doubleToLongBits(this.getLat());
        result = result * 59 + (int)($lat >>> 32 ^ $lat);
        long $lon = Double.doubleToLongBits(this.getLon());
        result = result * 59 + (int)($lon >>> 32 ^ $lon);
        String $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : $distance.hashCode());
        DistanceUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        org.elasticsearch.common.geo.GeoDistance $geoDistance = this.getGeoDistance();
        result = result * 59 + ($geoDistance == null ? 43 : $geoDistance.hashCode());
        return result;
    }

    public String toString() {
        return "GeoDistance(lat=" + this.getLat() + ", lon=" + this.getLon() + ", distance=" + this.getDistance() + ", unit=" + this.getUnit() + ", geoDistance=" + this.getGeoDistance() + ")";
    }
}

