/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.model.analysis;

import cn.zhangfusheng.elasticsearch.constant.enumeration.SearchKeyword;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.es.EsRange;
import cn.zhangfusheng.elasticsearch.model.es.GeoDistance;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class AnalysisSearchKeyword {
    public QueryBuilder builder(String k, Object v, SearchKeyword searchKeyword) {
        switch (searchKeyword) {
            case MATCH_ALL: {
                return QueryBuilders.matchAllQuery();
            }
            case MATCH: {
                return QueryBuilders.matchQuery((String)k, (Object)v);
            }
            case MULTI_MATCH: {
                return QueryBuilders.multiMatchQuery((Object)k, (String[])new String[]{String.valueOf(v)});
            }
            case MATCH_PHRASE: {
                return QueryBuilders.matchPhraseQuery((String)k, (Object)v);
            }
            case TERM: {
                return QueryBuilders.termQuery((String)k, (Object)v);
            }
            case FUZZY: {
                return QueryBuilders.fuzzyQuery((String)k, (Object)v);
            }
            case PREFIX: {
                return QueryBuilders.prefixQuery((String)k, (String)String.valueOf(v));
            }
            case RANGE: {
                if (v instanceof EsRange) {
                    return ((EsRange)v).builder(QueryBuilders.rangeQuery((String)k));
                }
                throw new GlobalSystemException("range query params muster instanceof {}", EsRange.class.getName());
            }
            case WILDCARD: {
                return QueryBuilders.wildcardQuery((String)k, (String)String.valueOf(v));
            }
            case REGEXP: {
                return QueryBuilders.regexpQuery((String)k, (String)String.valueOf(v));
            }
            case SPAN_TERM: {
                return QueryBuilders.spanTermQuery((String)k, (String)String.valueOf(v));
            }
            case TERMS: {
                if (v instanceof Collection) {
                    return QueryBuilders.termsQuery((String)k, (Collection)((Collection)v));
                }
                throw new GlobalSystemException("terms value master instanceof Collection");
            }
            case GEO_DISTANCE: {
                if (v instanceof GeoDistance) {
                    GeoDistance geoDistance = (GeoDistance)v;
                    if (StringUtils.isBlank((CharSequence)geoDistance.getDistance())) {
                        return null;
                    }
                    return QueryBuilders.geoDistanceQuery((String)k).point(geoDistance.getLat(), geoDistance.getLon()).distance(geoDistance.getDistance(), geoDistance.getUnit()).geoDistance(geoDistance.getGeoDistance());
                }
                throw new GlobalSystemException("geoDistanceQuery value master instanceof {}", GeoDistance.class.getName());
            }
            case GEO_BOUNDING_BOX: {
                return QueryBuilders.geoBoundingBoxQuery((String)k);
            }
            case EXISTS: {
                return QueryBuilders.existsQuery((String)k);
            }
        }
        throw new GlobalSystemException("\u4e0d\u652f\u6301\u7684\u641c\u7d22\u5173\u952e\u5b57");
    }
}

