/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.jexl.analysis.impl;

import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Execute;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Util;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class VariableAnalysis
implements Analysis {
    private String variableStr;

    public String toString() {
        return this.variableStr;
    }

    @Override
    public void execute(Jexl3Execute jexl3Execute) {
        Object o = Jexl3Util.execute(jexl3Execute.getParams(), jexl3Execute.getConstantParams(), Jexl3Util.toStr(this.variableStr));
        if (Objects.nonNull(o)) {
            if (o instanceof Collection || o.getClass().isArray() && o.getClass() != byte[].class) {
                Collection<?> collection = Jexl3Util.asCollection(o);
                if (collection.isEmpty()) {
                    jexl3Execute.setStr("NULL");
                } else {
                    collection.forEach(jexl3Execute::setValue);
                    jexl3Execute.setStr(collection.stream().map(c -> "?").collect(Collectors.joining(",")));
                }
            } else {
                jexl3Execute.setValue(o).setStr("?");
            }
        } else {
            throw new GlobalSystemException("{} value is empty", this.variableStr);
        }
    }

    public String getVariableStr() {
        return this.variableStr;
    }

    public void setVariableStr(String variableStr) {
        this.variableStr = variableStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableAnalysis)) {
            return false;
        }
        VariableAnalysis other = (VariableAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$variableStr = this.getVariableStr();
        String other$variableStr = other.getVariableStr();
        return !(this$variableStr == null ? other$variableStr != null : !this$variableStr.equals(other$variableStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $variableStr = this.getVariableStr();
        result = result * 59 + ($variableStr == null ? 43 : $variableStr.hashCode());
        return result;
    }

    public VariableAnalysis(String variableStr) {
        this.variableStr = variableStr;
    }
}

