/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.jexl.analysis.impl;

import cn.zhangfusheng.elasticsearch.jexl.Jexl3Execute;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Util;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ForAnalysis
implements Analysis {
    private String variable;
    private String forCondition;
    private String forExecute;
    private List<Analysis> forAnalyses;

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (Objects.nonNull(this.forCondition)) {
            str.append("for ( ").append(this.variable).append(" in ").append(this.forCondition).append(" ){");
            if (Objects.nonNull(this.forExecute)) {
                str.append(this.forExecute);
            }
            if (Objects.nonNull(this.forAnalyses)) {
                this.forAnalyses.forEach(analysis -> str.append(analysis.toString()));
            }
            str.append("}");
        }
        return str.toString();
    }

    @Override
    public void execute(Jexl3Execute jexl3Execute) {
        Object oldValue = jexl3Execute.getParams().get(this.variable);
        Object execute = Jexl3Util.execute(jexl3Execute.getParams(), jexl3Execute.getConstantParams(), Jexl3Util.toStr(this.forCondition));
        Jexl3Util.asCollection(execute).stream().peek(o -> jexl3Execute.setIndex(jexl3Execute.getIndex() + 1)).peek(o -> jexl3Execute.setParam("_index", jexl3Execute.getIndex())).peek(o -> jexl3Execute.setParam(this.variable, o)).forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)this.forExecute)) {
                jexl3Execute.setStr(this.forCondition);
            }
            if (!CollectionUtils.isEmpty(this.forAnalyses)) {
                this.forAnalyses.forEach(analysis -> analysis.execute(jexl3Execute));
            }
        });
        jexl3Execute.setIndex(0);
        jexl3Execute.setParam(this.variable, oldValue);
    }

    public String getVariable() {
        return this.variable;
    }

    public String getForCondition() {
        return this.forCondition;
    }

    public String getForExecute() {
        return this.forExecute;
    }

    public List<Analysis> getForAnalyses() {
        return this.forAnalyses;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setForCondition(String forCondition) {
        this.forCondition = forCondition;
    }

    public void setForExecute(String forExecute) {
        this.forExecute = forExecute;
    }

    public void setForAnalyses(List<Analysis> forAnalyses) {
        this.forAnalyses = forAnalyses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForAnalysis)) {
            return false;
        }
        ForAnalysis other = (ForAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$variable = this.getVariable();
        String other$variable = other.getVariable();
        if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
            return false;
        }
        String this$forCondition = this.getForCondition();
        String other$forCondition = other.getForCondition();
        if (this$forCondition == null ? other$forCondition != null : !this$forCondition.equals(other$forCondition)) {
            return false;
        }
        String this$forExecute = this.getForExecute();
        String other$forExecute = other.getForExecute();
        if (this$forExecute == null ? other$forExecute != null : !this$forExecute.equals(other$forExecute)) {
            return false;
        }
        List<Analysis> this$forAnalyses = this.getForAnalyses();
        List<Analysis> other$forAnalyses = other.getForAnalyses();
        return !(this$forAnalyses == null ? other$forAnalyses != null : !((Object)this$forAnalyses).equals(other$forAnalyses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        String $forCondition = this.getForCondition();
        result = result * 59 + ($forCondition == null ? 43 : $forCondition.hashCode());
        String $forExecute = this.getForExecute();
        result = result * 59 + ($forExecute == null ? 43 : $forExecute.hashCode());
        List<Analysis> $forAnalyses = this.getForAnalyses();
        result = result * 59 + ($forAnalyses == null ? 43 : ((Object)$forAnalyses).hashCode());
        return result;
    }
}

