/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.factory;

import cn.zhangfusheng.elasticsearch.cycle.InitTransferBefore;
import cn.zhangfusheng.elasticsearch.factory.proxy.RepositoryCglibProxy;
import cn.zhangfusheng.elasticsearch.factory.proxy.RepositoryJdkProxy;
import cn.zhangfusheng.elasticsearch.factory.proxy.RepositoryProxy;
import cn.zhangfusheng.elasticsearch.mybatis.ElasticSearchWithMybatisXmlConfig;
import cn.zhangfusheng.elasticsearch.repository.DefaultElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchRestTemplate;
import cn.zhangfusheng.elasticsearch.transfer.TransferInfo;
import cn.zhangfusheng.elasticsearch.transfer.TransferOperation;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ElasticSearchRepositoryFactoryBean<T extends ElasticSearchRepository<?>>
implements FactoryBean<T>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchRepositoryFactoryBean.class);
    private ElasticSearchEntityRepositoryDetail entityRepositoryDetail;
    private DefaultListableBeanFactory beanFactory;
    private ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig;
    private Class<? extends ElasticSearchRepository<?>> objectType;
    private AdviceMode adviceMode;
    private ElasticSearchRepository<?> defaultElasticSearchRepository;
    private ElasticSearchRestTemplate elasticSearchRestTemplate;
    private String indexName;
    private T object;

    public T getObject() {
        if (Objects.isNull(this.object)) {
            this.object = this.createObject();
        }
        return this.object;
    }

    private T createObject() {
        if (!this.entityRepositoryDetail.isIgnoreTransferOperation()) {
            new TransferOperation(this.entityRepositoryDetail, this.elasticSearchRestTemplate).operationDocumentAndTransferDb();
        }
        RepositoryProxy repositoryCglibProxy = this.adviceMode.equals((Object)AdviceMode.PROXY) ? new RepositoryJdkProxy(this.defaultElasticSearchRepository, this.entityRepositoryDetail, this.elasticSearchRestTemplate, this.elasticSearchWithMybatisXmlConfig) : new RepositoryCglibProxy(this.defaultElasticSearchRepository, this.entityRepositoryDetail, this.elasticSearchRestTemplate, this.elasticSearchWithMybatisXmlConfig);
        return repositoryCglibProxy.getObject();
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"beanFactory must not be null");
        Assert.notNull((Object)this.entityRepositoryDetail, (String)"entityRepositoryDetail must not be null");
        RestHighLevelClient restHighLevelClient = (RestHighLevelClient)this.beanFactory.getBean(RestHighLevelClient.class);
        this.elasticSearchRestTemplate = new ElasticSearchRestTemplate(restHighLevelClient);
        this.defaultElasticSearchRepository = new DefaultElasticSearchRepository(this.elasticSearchRestTemplate, this.entityRepositoryDetail);
        this.indexName = this.entityRepositoryDetail.getIndexName();
        this.initTransfer();
    }

    private void initTransfer() {
        if (!Objects.equals(this.entityRepositoryDetail.getEntityClass(), TransferInfo.class)) {
            return;
        }
        boolean indexExists = this.elasticSearchRestTemplate.exists(new GetIndexRequest(new String[]{this.indexName}));
        if (!indexExists) {
            Map initTransferBeforeMap = this.beanFactory.getBeansOfType(InitTransferBefore.class);
            if (!CollectionUtils.isEmpty((Map)initTransferBeforeMap)) {
                initTransferBeforeMap.values().forEach(r -> r.run(this.elasticSearchRestTemplate));
            }
            this.elasticSearchRestTemplate.createIndexMapping(this.indexName, this.entityRepositoryDetail.getMapping());
            if (log.isDebugEnabled()) {
                log.debug("create transfer index success");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("transfer index exists:{}", (Object)indexExists);
        }
    }

    public ElasticSearchEntityRepositoryDetail getEntityRepositoryDetail() {
        return this.entityRepositoryDetail;
    }

    public DefaultListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public ElasticSearchWithMybatisXmlConfig getElasticSearchWithMybatisXmlConfig() {
        return this.elasticSearchWithMybatisXmlConfig;
    }

    public AdviceMode getAdviceMode() {
        return this.adviceMode;
    }

    public ElasticSearchRepository<?> getDefaultElasticSearchRepository() {
        return this.defaultElasticSearchRepository;
    }

    public ElasticSearchRestTemplate getElasticSearchRestTemplate() {
        return this.elasticSearchRestTemplate;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setEntityRepositoryDetail(ElasticSearchEntityRepositoryDetail entityRepositoryDetail) {
        this.entityRepositoryDetail = entityRepositoryDetail;
    }

    public void setBeanFactory(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setElasticSearchWithMybatisXmlConfig(ElasticSearchWithMybatisXmlConfig elasticSearchWithMybatisXmlConfig) {
        this.elasticSearchWithMybatisXmlConfig = elasticSearchWithMybatisXmlConfig;
    }

    public void setObjectType(Class<? extends ElasticSearchRepository<?>> objectType) {
        this.objectType = objectType;
    }

    public void setAdviceMode(AdviceMode adviceMode) {
        this.adviceMode = adviceMode;
    }

    public void setDefaultElasticSearchRepository(ElasticSearchRepository<?> defaultElasticSearchRepository) {
        this.defaultElasticSearchRepository = defaultElasticSearchRepository;
    }

    public void setElasticSearchRestTemplate(ElasticSearchRestTemplate elasticSearchRestTemplate) {
        this.elasticSearchRestTemplate = elasticSearchRestTemplate;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchRepositoryFactoryBean)) {
            return false;
        }
        ElasticSearchRepositoryFactoryBean other = (ElasticSearchRepositoryFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ElasticSearchEntityRepositoryDetail this$entityRepositoryDetail = this.getEntityRepositoryDetail();
        ElasticSearchEntityRepositoryDetail other$entityRepositoryDetail = other.getEntityRepositoryDetail();
        if (this$entityRepositoryDetail == null ? other$entityRepositoryDetail != null : !((Object)this$entityRepositoryDetail).equals(other$entityRepositoryDetail)) {
            return false;
        }
        DefaultListableBeanFactory this$beanFactory = this.getBeanFactory();
        DefaultListableBeanFactory other$beanFactory = other.getBeanFactory();
        if (this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory)) {
            return false;
        }
        ElasticSearchWithMybatisXmlConfig this$elasticSearchWithMybatisXmlConfig = this.getElasticSearchWithMybatisXmlConfig();
        ElasticSearchWithMybatisXmlConfig other$elasticSearchWithMybatisXmlConfig = other.getElasticSearchWithMybatisXmlConfig();
        if (this$elasticSearchWithMybatisXmlConfig == null ? other$elasticSearchWithMybatisXmlConfig != null : !((Object)((Object)this$elasticSearchWithMybatisXmlConfig)).equals((Object)other$elasticSearchWithMybatisXmlConfig)) {
            return false;
        }
        Class<?> this$objectType = this.getObjectType();
        Class<?> other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        AdviceMode this$adviceMode = this.getAdviceMode();
        AdviceMode other$adviceMode = other.getAdviceMode();
        if (this$adviceMode == null ? other$adviceMode != null : !this$adviceMode.equals(other$adviceMode)) {
            return false;
        }
        ElasticSearchRepository<?> this$defaultElasticSearchRepository = this.getDefaultElasticSearchRepository();
        ElasticSearchRepository<?> other$defaultElasticSearchRepository = other.getDefaultElasticSearchRepository();
        if (this$defaultElasticSearchRepository == null ? other$defaultElasticSearchRepository != null : !this$defaultElasticSearchRepository.equals(other$defaultElasticSearchRepository)) {
            return false;
        }
        ElasticSearchRestTemplate this$elasticSearchRestTemplate = this.getElasticSearchRestTemplate();
        ElasticSearchRestTemplate other$elasticSearchRestTemplate = other.getElasticSearchRestTemplate();
        if (this$elasticSearchRestTemplate == null ? other$elasticSearchRestTemplate != null : !this$elasticSearchRestTemplate.equals(other$elasticSearchRestTemplate)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchRepositoryFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ElasticSearchEntityRepositoryDetail $entityRepositoryDetail = this.getEntityRepositoryDetail();
        result = result * 59 + ($entityRepositoryDetail == null ? 43 : ((Object)$entityRepositoryDetail).hashCode());
        DefaultListableBeanFactory $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        ElasticSearchWithMybatisXmlConfig $elasticSearchWithMybatisXmlConfig = this.getElasticSearchWithMybatisXmlConfig();
        result = result * 59 + ($elasticSearchWithMybatisXmlConfig == null ? 43 : ((Object)((Object)$elasticSearchWithMybatisXmlConfig)).hashCode());
        Class<?> $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        AdviceMode $adviceMode = this.getAdviceMode();
        result = result * 59 + ($adviceMode == null ? 43 : $adviceMode.hashCode());
        ElasticSearchRepository<?> $defaultElasticSearchRepository = this.getDefaultElasticSearchRepository();
        result = result * 59 + ($defaultElasticSearchRepository == null ? 43 : $defaultElasticSearchRepository.hashCode());
        ElasticSearchRestTemplate $elasticSearchRestTemplate = this.getElasticSearchRestTemplate();
        result = result * 59 + ($elasticSearchRestTemplate == null ? 43 : $elasticSearchRestTemplate.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchRepositoryFactoryBean(entityRepositoryDetail=" + this.getEntityRepositoryDetail() + ", beanFactory=" + this.getBeanFactory() + ", elasticSearchWithMybatisXmlConfig=" + (Object)((Object)this.getElasticSearchWithMybatisXmlConfig()) + ", objectType=" + this.getObjectType() + ", adviceMode=" + this.getAdviceMode() + ", defaultElasticSearchRepository=" + this.getDefaultElasticSearchRepository() + ", elasticSearchRestTemplate=" + this.getElasticSearchRestTemplate() + ", indexName=" + this.getIndexName() + ", object=" + this.getObject() + ")";
    }
}

