package cn.zhangfusheng.elasticsearch.annotation.document.field;

import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.Alias;
import cn.zhangfusheng.elasticsearch.annotation.document.field.parameters.GeoPoint;
import cn.zhangfusheng.elasticsearch.constant.enumeration.FieldType;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 字段映射配置
 * @author fusheng.zhang
 * @date 2022-02-24 15:15:35
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface FieldMapping {

    /**
     * 主键
     * @return
     */
    boolean primaryId() default false;

    /**
     * routing
     * @return
     */
    boolean routing() default false;

    /**
     * 忽略字段
     * @return
     */
    boolean ignore() default false;

    /**
     * 字段类型
     * @return
     */
    FieldType type() default FieldType.Text;

    /**
     * mapping parameters<br/>
     * 最多只能配置1个
     * @return
     */
    MappingParameters[] patameters() default {};

    /**
     * geo point 属性补充
     * @return
     */
    GeoPoint[] geoPoints() default {};

    /**
     * alias 类型的补充
     * @return
     */
    Alias[] alias() default {};
}
