/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.template;

import cn.zhangfusheng.elasticsearch.constant.ElasticSearchConstant;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.model.page.PageRequest;
import cn.zhangfusheng.elasticsearch.repository.ElasticSearchRepository;
import cn.zhangfusheng.elasticsearch.scan.ElasticSearchEntityRepositoryDetail;
import cn.zhangfusheng.elasticsearch.sql.DslWithSqlAnalysis;
import cn.zhangfusheng.elasticsearch.sql.SqlAnalysisDetail;
import cn.zhangfusheng.elasticsearch.sql.SqlExecuteResult;
import cn.zhangfusheng.elasticsearch.sql.es.ElasticSql2DslParser;
import cn.zhangfusheng.elasticsearch.template.ElasticSearchTemplateApi;
import cn.zhangfusheng.elasticsearch.template.Template;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TemplateDynamicSqlApi
extends Template,
ElasticSearchTemplateApi {
    public static final Logger log = LoggerFactory.getLogger(TemplateDynamicSqlApi.class);

    default public Object runDynamicSql(ElasticSearchEntityRepositoryDetail entityRepositoryDetail, Class<? extends ElasticSearchRepository<?>> daoClass, Method method, Object[] args, String routing, String index) {
        try {
            SqlAnalysisDetail sqlAnalysisDetail = new DslWithSqlAnalysis().analysis(daoClass, method);
            SqlExecuteResult execute = sqlAnalysisDetail.execute(args);
            String sql = execute.getSql().toString();
            Iterator<Object> iterator = execute.getArgs().iterator();
            while (sql.contains("?")) {
                Object o2;
                Object object = o2 = iterator.hasNext() ? iterator.next() : "";
                if (o2 instanceof String) {
                    o2 = String.format("'%s'", o2);
                }
                sql = sql.replaceFirst("\\?", String.valueOf(o2));
            }
            log.debug("result sql:{}", (Object)ElasticSearchConstant.PATTERN.matcher(sql).replaceAll(" "));
            ElasticSqlParseResult parseResult = new ElasticSql2DslParser().parse(sql);
            SearchSourceBuilder searchSourceBuilder = parseResult.getSearchRequest().source();
            searchSourceBuilder.trackTotalHitsUpTo(10000);
            String[] indices = this.analysisIndex(method, args, index);
            SearchRequest searchRequest = parseResult.getSearchRequest().source(searchSourceBuilder).routing(routing).indices(indices);
            Optional<PageRequest> pageRequestOptional = Arrays.stream(args).filter(o -> o instanceof PageRequest).map(o -> (PageRequest)o).findFirst();
            return this.search(entityRepositoryDetail, method, searchRequest, pageRequestOptional.orElse(null));
        }
        catch (IOException e) {
            throw new GlobalSystemException(e);
        }
    }
}

