/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.sql.es;

import cn.zhangfusheng.elasticsearch.sql.es.QueryOrderByParser;
import com.google.common.collect.ImmutableList;
import io.github.iamazy.elasticsearch.dsl.antlr4.ElasticsearchParser;
import io.github.iamazy.elasticsearch.dsl.antlr4.Walker;
import io.github.iamazy.elasticsearch.dsl.sql.exception.ElasticSql2DslException;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticDslContext;
import io.github.iamazy.elasticsearch.dsl.sql.model.ElasticSqlParseResult;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryFromParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryLimitParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryRoutingsParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QuerySelectFieldsParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.QueryWhereConditionParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.aggs.AggregateByQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.delete.DeleteQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.desc.QueryDescParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.insert.InsertQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.query.score.DisMaxQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.reindex.ReindexQueryParser;
import io.github.iamazy.elasticsearch.dsl.sql.parser.update.UpdateQueryParser;
import java.util.List;

public class ElasticSql2DslParser {
    public ElasticSqlParseResult parse(String sql) throws ElasticSql2DslException {
        Walker walker = new Walker(sql);
        ElasticsearchParser.SqlContext sqlContext = walker.buildAntlrTree();
        ElasticDslContext elasticDslContext = new ElasticDslContext(sqlContext);
        this.buildSqlParserChain().forEach(parser -> parser.parse(elasticDslContext));
        return elasticDslContext.getParseResult();
    }

    private List<QueryParser> buildSqlParserChain() {
        return ImmutableList.of((Object)new QuerySelectFieldsParser(), (Object)new QueryFromParser(), (Object)new QueryWhereConditionParser(), (Object)new DisMaxQueryParser(), (Object)new QueryRoutingsParser(), (Object)new AggregateByQueryParser(), (Object)new QueryOrderByParser(), (Object)new QueryLimitParser(), (Object)new QueryDescParser(), (Object)new ReindexQueryParser(), (Object)new InsertQueryParser(), (Object)new UpdateQueryParser(), (Object[])new QueryParser[]{new DeleteQueryParser()});
    }
}

