/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.sql;

import cn.zhangfusheng.elasticsearch.annotation.dsl.DslParams;
import cn.zhangfusheng.elasticsearch.annotation.dsl.sql.DslWithSql;
import cn.zhangfusheng.elasticsearch.annotation.dsl.sql.condition.SqlCondition;
import cn.zhangfusheng.elasticsearch.exception.GlobalSystemException;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Analysis;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import cn.zhangfusheng.elasticsearch.sql.SqlAnalysisDetail;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DslWithSqlAnalysis {
    private final Map<Method, SqlAnalysisDetail> methodAnalysis = new HashMap<Method, SqlAnalysisDetail>();
    private final Map<Class<?>, Map<String, Object>> constantParamsCache = new HashMap();

    public SqlAnalysisDetail analysis(Class<?> clazz, Method method) {
        DslWithSql dslWithSql = method.getAnnotation(DslWithSql.class);
        if (Objects.isNull(dslWithSql)) {
            return null;
        }
        if (!this.methodAnalysis.containsKey(method)) {
            List<Analysis> analyses = new Jexl3Analysis(dslWithSql.value()).compile();
            List<SqlCondition> sqlConditions = Arrays.asList(dslWithSql.conditions());
            Map<SqlCondition, List<Analysis>> conditionAnalyses = sqlConditions.stream().collect(Collectors.toMap(o -> o, o -> new Jexl3Analysis(o.value()).compile()));
            Parameter[] parameters = method.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                DslParams annotation = parameter.getAnnotation(DslParams.class);
                if (Objects.nonNull(annotation) && StringUtils.isNotBlank((CharSequence)annotation.value())) {
                    parameterNames.add(annotation.value());
                    continue;
                }
                parameterNames.add(String.format("arg_%s", i + 1));
            }
            Map<String, Object> constantParams = this.getConstantParams(clazz);
            SqlAnalysisDetail sqlAnalysisDetail = new SqlAnalysisDetail(constantParams, parameterNames, dslWithSql, analyses, sqlConditions, conditionAnalyses);
            this.methodAnalysis.put(method, sqlAnalysisDetail);
        }
        return this.methodAnalysis.get(method);
    }

    private Map<String, Object> getConstantParams(Class<?> clazz) {
        if (!this.constantParamsCache.containsKey(clazz)) {
            ArrayList clazzList = new ArrayList(Arrays.asList(clazz.getInterfaces()));
            clazzList.add(clazz);
            Class<?> superclass = clazz.getSuperclass();
            while (Objects.nonNull(superclass)) {
                if (!Objects.nonNull(superclass = superclass.getSuperclass())) continue;
                clazzList.add(superclass);
            }
            Map<String, Object> constantParams = clazzList.stream().map(c -> Arrays.asList(c.getDeclaredFields())).flatMap(Collection::stream).filter(Objects::nonNull).filter(o -> !o.isSynthetic() && Modifier.isStatic(o.getModifiers())).collect(Collectors.toMap(Field::getName, o -> {
                try {
                    o.setAccessible(true);
                    Object object = o.get(null);
                    return object;
                }
                catch (IllegalAccessException e) {
                    throw new GlobalSystemException(e);
                }
                finally {
                    assert (o != null);
                    o.setAccessible(false);
                }
            }));
            this.constantParamsCache.put(clazz, constantParams);
        }
        return this.constantParamsCache.get(clazz);
    }
}

