/*
 * Decompiled with CFR 0.152.
 */
package cn.zhangfusheng.elasticsearch.jexl.analysis.impl;

import cn.zhangfusheng.elasticsearch.jexl.Jexl3Execute;
import cn.zhangfusheng.elasticsearch.jexl.Jexl3Util;
import cn.zhangfusheng.elasticsearch.jexl.analysis.Analysis;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class IfElseAnalysis
implements Analysis {
    private String ifCondition;
    private String ifExecute;
    private List<Analysis> ifAnalyses;
    private String elseExecute;
    private List<Analysis> elseAnalyses;

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (Objects.nonNull(this.ifCondition)) {
            str.append("if(").append(this.ifCondition).append(")").append("{");
            if (Objects.nonNull(this.ifExecute)) {
                str.append(this.ifExecute);
            }
            if (Objects.nonNull(this.ifAnalyses)) {
                this.ifAnalyses.forEach(analysis -> str.append(analysis.toString()));
            }
            str.append("}");
            if (Objects.nonNull(this.elseExecute)) {
                str.append(" else {").append(this.elseExecute).append("}");
            }
            if (Objects.nonNull(this.elseAnalyses)) {
                str.append(" else {");
                this.elseAnalyses.forEach(analysis -> str.append(analysis.toString()));
                str.append("}");
            }
        }
        return str.toString();
    }

    @Override
    public void execute(Jexl3Execute jexl3Execute) {
        Object o = Jexl3Util.execute(jexl3Execute.getParams(), jexl3Execute.getConstantParams(), Jexl3Util.toStr(this.ifCondition));
        if (Objects.nonNull(o) && Boolean.parseBoolean(o.toString())) {
            if (StringUtils.isNotBlank((CharSequence)this.ifExecute)) {
                jexl3Execute.setStr(this.ifExecute);
            }
            if (!CollectionUtils.isEmpty(this.ifAnalyses)) {
                this.ifAnalyses.forEach(analysis -> analysis.execute(jexl3Execute));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)this.elseExecute)) {
                jexl3Execute.setStr(this.elseExecute);
            }
            if (!CollectionUtils.isEmpty(this.elseAnalyses)) {
                this.elseAnalyses.forEach(analysis -> analysis.execute(jexl3Execute));
            }
        }
    }

    public String getIfCondition() {
        return this.ifCondition;
    }

    public String getIfExecute() {
        return this.ifExecute;
    }

    public List<Analysis> getIfAnalyses() {
        return this.ifAnalyses;
    }

    public String getElseExecute() {
        return this.elseExecute;
    }

    public List<Analysis> getElseAnalyses() {
        return this.elseAnalyses;
    }

    public void setIfCondition(String ifCondition) {
        this.ifCondition = ifCondition;
    }

    public void setIfExecute(String ifExecute) {
        this.ifExecute = ifExecute;
    }

    public void setIfAnalyses(List<Analysis> ifAnalyses) {
        this.ifAnalyses = ifAnalyses;
    }

    public void setElseExecute(String elseExecute) {
        this.elseExecute = elseExecute;
    }

    public void setElseAnalyses(List<Analysis> elseAnalyses) {
        this.elseAnalyses = elseAnalyses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IfElseAnalysis)) {
            return false;
        }
        IfElseAnalysis other = (IfElseAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ifCondition = this.getIfCondition();
        String other$ifCondition = other.getIfCondition();
        if (this$ifCondition == null ? other$ifCondition != null : !this$ifCondition.equals(other$ifCondition)) {
            return false;
        }
        String this$ifExecute = this.getIfExecute();
        String other$ifExecute = other.getIfExecute();
        if (this$ifExecute == null ? other$ifExecute != null : !this$ifExecute.equals(other$ifExecute)) {
            return false;
        }
        List<Analysis> this$ifAnalyses = this.getIfAnalyses();
        List<Analysis> other$ifAnalyses = other.getIfAnalyses();
        if (this$ifAnalyses == null ? other$ifAnalyses != null : !((Object)this$ifAnalyses).equals(other$ifAnalyses)) {
            return false;
        }
        String this$elseExecute = this.getElseExecute();
        String other$elseExecute = other.getElseExecute();
        if (this$elseExecute == null ? other$elseExecute != null : !this$elseExecute.equals(other$elseExecute)) {
            return false;
        }
        List<Analysis> this$elseAnalyses = this.getElseAnalyses();
        List<Analysis> other$elseAnalyses = other.getElseAnalyses();
        return !(this$elseAnalyses == null ? other$elseAnalyses != null : !((Object)this$elseAnalyses).equals(other$elseAnalyses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IfElseAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ifCondition = this.getIfCondition();
        result = result * 59 + ($ifCondition == null ? 43 : $ifCondition.hashCode());
        String $ifExecute = this.getIfExecute();
        result = result * 59 + ($ifExecute == null ? 43 : $ifExecute.hashCode());
        List<Analysis> $ifAnalyses = this.getIfAnalyses();
        result = result * 59 + ($ifAnalyses == null ? 43 : ((Object)$ifAnalyses).hashCode());
        String $elseExecute = this.getElseExecute();
        result = result * 59 + ($elseExecute == null ? 43 : $elseExecute.hashCode());
        List<Analysis> $elseAnalyses = this.getElseAnalyses();
        result = result * 59 + ($elseAnalyses == null ? 43 : ((Object)$elseAnalyses).hashCode());
        return result;
    }
}

