/*
 * Decompiled with CFR 0.152.
 */
package cn.yusiwen.commons.mapper;

import cn.yusiwen.commons.mapper.ObjectUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static Field[] getFields(Class<?> clazz) {
        return ReflectUtil.getFields(clazz, null);
    }

    public static Field[] getFields(Class<?> clazz, Predicate<Field> fieldFilter) {
        ArrayList<Field> fields = new ArrayList<Field>(32);
        while (Object.class != clazz && clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (fieldFilter != null && !fieldFilter.test(field)) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    public static void doWithFields(Class<?> clazz, Consumer<Field> consumer) {
        Arrays.stream(ReflectUtil.getFields(clazz)).forEach(consumer);
    }

    public static Field getField(Class<?> clazz, String name) {
        return ReflectUtil.getField(clazz, name, null);
    }

    public static Field getField(Class<?> clazz, String name, Class<?> type) {
        while (clazz != Object.class && clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"})
    public static Object getFieldValue(Field field, Object target) {
        ReflectUtil.makeAccessible(field);
        try {
            return field.get(target);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("\u83b7\u53d6%s\u5bf9\u8c61\u7684%s\u5b57\u6bb5\u503c\u9519\u8bef!", target.getClass().getName(), field.getName()), e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (ObjectUtil.isWrapperOrPrimitive(obj)) {
            return obj;
        }
        return ReflectUtil.getFieldValue(ReflectUtil.getField(obj.getClass(), fieldName), obj);
    }

    public static Object getValueByFieldPath(Object obj, String fieldPath) {
        String[] fieldNames = fieldPath.split("\\.");
        Object result = null;
        for (String fieldName : fieldNames) {
            result = ReflectUtil.getFieldValue(obj, fieldName);
            if (result == null) {
                return null;
            }
            obj = result;
        }
        return result;
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"})
    public static void setFieldValue(Field field, Object target, Object value) {
        ReflectUtil.makeAccessible(field);
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("\u8bbe\u7f6e%s\u5bf9\u8c61\u7684%s\u5b57\u6bb5\u503c\u9519\u8bef!", target.getClass().getName(), field.getName()), e);
        }
    }

    @SuppressFBWarnings(value={"RFI_SET_ACCESSIBLE"})
    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectUtil.invokeMethod(method, target, new Object[0]);
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"})
    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            ReflectUtil.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("\u6267\u884c%s.%s()\u65b9\u6cd5\u9519\u8bef!", target.getClass().getName(), method.getName()), ex);
        }
    }

    @SuppressFBWarnings(value={"RFI_SET_ACCESSIBLE"})
    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static boolean isEqualsMethod(Method method) {
        if (!"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return "hashCode".equals(method.getName()) && method.getParameterCount() == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return "toString".equals(method.getName()) && method.getParameterCount() == 0;
    }
}

