/*
 * Decompiled with CFR 0.152.
 */
package cn.yusiwen.commons.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(int size, T ... ele) {
        ArrayList<T> al = new ArrayList<T>(size);
        al.addAll(Arrays.asList(ele));
        return al;
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... ele) {
        return new ArrayList<T>(Arrays.asList(ele));
    }

    public static <T> boolean contains(Collection<T> collection, T value) {
        return !CollectionUtil.isEmpty(collection) && collection.contains(value);
    }

    public static String joinSeparator2String(Collection<?> collection, String separator) {
        return collection.stream().map(String::valueOf).collect(Collectors.joining(separator));
    }

    public static <T extends Comparable<T>> CompareResult<T> compare(Collection<T> newCollection, Collection<T> oldCollection) {
        Set unmodifiedSet;
        Set<Comparable> deleteSet;
        HashSet addSet;
        Set<Comparable> oldSet;
        HashSet newSet;
        HashSet<Object> hashSet = CollectionUtil.isEmpty(newCollection) ? Collections.emptySet() : (newSet = newCollection instanceof Set ? (HashSet)newCollection : new HashSet<T>(newCollection));
        Set<Comparable> set = CollectionUtil.isEmpty(oldCollection) ? Collections.emptySet() : (oldSet = oldCollection instanceof Set ? (Set<Comparable>)oldCollection : new HashSet<T>(oldCollection));
        if (newSet.isEmpty()) {
            addSet = Collections.emptySet();
            deleteSet = oldSet;
            unmodifiedSet = Collections.emptySet();
        } else if (oldSet.isEmpty()) {
            addSet = newSet;
            deleteSet = Collections.emptySet();
            unmodifiedSet = Collections.emptySet();
        } else {
            deleteSet = new HashSet<Comparable>();
            unmodifiedSet = new HashSet(oldSet.size());
            addSet = new HashSet(newSet);
            for (Comparable old : oldSet) {
                if (addSet.remove(old)) {
                    unmodifiedSet.add(old);
                    continue;
                }
                deleteSet.add(old);
            }
        }
        return new CompareResult<Comparable>(addSet, deleteSet, unmodifiedSet);
    }

    public static <T> CompareResult<T> compare(Collection<T> newCollection, Collection<T> oldCollection, Comparator<T> comparator) {
        List<Object> newList;
        List<Object> list = CollectionUtil.isEmpty(newCollection) ? Collections.emptyList() : (newList = newCollection instanceof List ? (List<Object>)newCollection : new ArrayList<T>(newCollection));
        List<Object> oldList = CollectionUtil.isEmpty(oldCollection) ? Collections.emptyList() : (oldCollection instanceof List ? (List<Object>)oldCollection : new ArrayList<T>(oldCollection));
        return CollectionUtil.compare(newList, oldList, comparator);
    }

    public static <T> CompareResult<T> compare(List<T> newList, List<T> oldList, Comparator<T> comparator) {
        Set unmodifiedSet;
        Set<Object> deleteSet;
        HashSet<Object> addSet;
        if (CollectionUtil.isEmpty(newList)) {
            addSet = Collections.emptySet();
            deleteSet = CollectionUtil.isEmpty(oldList) ? Collections.emptySet() : new HashSet<T>(oldList);
            unmodifiedSet = Collections.emptySet();
        } else if (CollectionUtil.isEmpty(oldList)) {
            addSet = CollectionUtil.isEmpty(newList) ? Collections.emptySet() : new HashSet<T>(newList);
            deleteSet = Collections.emptySet();
            unmodifiedSet = Collections.emptySet();
        } else {
            int newSize = newList.size();
            int oldSize = oldList.size();
            int newIdx = 0;
            int oldIdx = 0;
            newList.sort(comparator);
            oldList.sort(comparator);
            addSet = new HashSet(newSize);
            deleteSet = new HashSet();
            unmodifiedSet = new HashSet(oldSize);
            while (newIdx < newSize && oldIdx < oldSize) {
                T oldOne;
                T newOne = newList.get(newIdx);
                int compare = comparator.compare(newOne, oldOne = oldList.get(oldIdx));
                if (compare == 0) {
                    unmodifiedSet.add(oldOne);
                    while (++oldIdx < oldSize && comparator.compare(oldOne, oldList.get(oldIdx)) == 0) {
                    }
                    while (++newIdx < newSize && comparator.compare(newOne, newList.get(newIdx)) == 0) {
                    }
                    continue;
                }
                if (compare < 0) {
                    addSet.add(newOne);
                    ++newIdx;
                    continue;
                }
                deleteSet.add(oldOne);
                ++oldIdx;
            }
            if (newIdx < newSize) {
                addSet.addAll(newList.subList(newIdx, newSize));
            }
            if (oldIdx < oldSize) {
                deleteSet.addAll(oldList.subList(oldIdx, oldSize));
            }
        }
        return new CompareResult<T>(addSet, deleteSet, unmodifiedSet);
    }

    public static class CompareResult<T> {
        private final Set<T> addValue;
        private final Set<T> delValue;
        private final Set<T> unmodifiedValue;

        public CompareResult(Set<T> addValue, Set<T> delValue, Set<T> unmodifiedValue) {
            this.addValue = addValue;
            this.delValue = delValue;
            this.unmodifiedValue = unmodifiedValue;
        }

        @Generated
        public Set<T> getAddValue() {
            return this.addValue;
        }

        @Generated
        public Set<T> getDelValue() {
            return this.delValue;
        }

        @Generated
        public Set<T> getUnmodifiedValue() {
            return this.unmodifiedValue;
        }
    }
}

