/*
 * Decompiled with CFR 0.152.
 */
package cn.yusiwen.commons.mapper;

import cn.yusiwen.commons.mapper.BaseEntity;
import cn.yusiwen.commons.mapper.CollectionUtil;
import cn.yusiwen.commons.mapper.ReflectUtil;
import cn.yusiwen.commons.mapper.StrUtil;
import cn.yusiwen.commons.mapper.annotation.JSONColumn;
import cn.yusiwen.commons.mapper.annotation.NotColumn;
import cn.yusiwen.commons.mapper.annotation.PrimaryKey;
import cn.yusiwen.commons.mapper.annotation.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.jdbc.SQL;

public interface BaseMapper<S extends BaseEntity> {
    @Options(useGeneratedKeys=true, keyProperty="id", keyColumn="id")
    @InsertProvider(type=InsertWithoutPrimaryKeySqlProvider.class, method="sql")
    public void insert(S var1);

    @SelectProvider(type=SelectOneSqlProvider.class, method="sql")
    public S queryById(Long var1);

    public static class TableInfo {
        private static final String DEFAULT_PRIMARY_KEY = "id";
        private String tableName;
        private String primaryKeyColumn;
        private Field[] fields;
        private Field[] fieldsWithoutPrimaryKey;
        private String[] columns;
        private String[] columnsWithoutPrimaryKey;
        private String[] selectColumns;

        private TableInfo() {
        }

        public static TableInfo of(Class<?> mapperType) {
            Class<?> entityClass = TableInfo.entityType(mapperType);
            Field[] fields = TableInfo.excludeNotColumnField(entityClass);
            TableInfo tableInfo = new TableInfo();
            tableInfo.fields = fields;
            tableInfo.fieldsWithoutPrimaryKey = (Field[])Arrays.stream(tableInfo.fields).filter(f -> !f.isAnnotationPresent(PrimaryKey.class)).toArray(Field[]::new);
            tableInfo.tableName = TableInfo.tableName(entityClass);
            tableInfo.primaryKeyColumn = TableInfo.primaryKeyColumn(fields);
            tableInfo.columns = TableInfo.columns(fields);
            tableInfo.columnsWithoutPrimaryKey = (String[])Arrays.stream(tableInfo.columns).filter(s -> !s.equals(tableInfo.primaryKeyColumn)).toArray(String[]::new);
            tableInfo.selectColumns = TableInfo.selectColumns(fields);
            return tableInfo;
        }

        public static Class<?> entityType(Class<?> mapperType) {
            return Stream.of(mapperType.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(type -> BaseMapper.class.isAssignableFrom((Class)type.getRawType())).findFirst().map(type -> type.getActualTypeArguments()[0]).filter(Class.class::isInstance).map(Class.class::cast).orElseThrow(() -> new IllegalStateException("\u672a\u627e\u5230BaseMapper\u7684\u6cdb\u578b\u7c7b " + mapperType.getName() + "."));
        }

        public static String tableName(Class<?> entityType) {
            return Optional.ofNullable(entityType.getAnnotation(Table.class)).orElseThrow(IllegalStateException::new).value();
        }

        public static Field[] excludeNotColumnField(Class<?> entityClass) {
            Field[] allFields = ReflectUtil.getFields(entityClass);
            List<String> excludeColumns = TableInfo.getClassExcludeColumns(entityClass);
            return (Field[])Stream.of(allFields).filter(field -> !CollectionUtil.contains(excludeColumns, field.getName()) && !field.isAnnotationPresent(NotColumn.class) && !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new);
        }

        public static List<String> getClassExcludeColumns(Class<?> entityClass) {
            List<String> excludeColumns = null;
            NotColumn classNoColumns = entityClass.getAnnotation(NotColumn.class);
            if (classNoColumns != null) {
                excludeColumns = Arrays.asList(classNoColumns.fields());
            }
            return excludeColumns;
        }

        public static String[] selectColumns(Field[] fields) {
            return (String[])Stream.of(fields).map(TableInfo::selectColumnName).toArray(String[]::new);
        }

        public static String[] columns(Field[] fields) {
            return (String[])Stream.of(fields).map(TableInfo::columnName).toArray(String[]::new);
        }

        public static String primaryKeyColumn(Field[] fields) {
            return Stream.of(fields).filter(field -> field.isAnnotationPresent(PrimaryKey.class)).findFirst().map(TableInfo::columnName).orElse(DEFAULT_PRIMARY_KEY);
        }

        public static String selectColumnName(Field field) {
            String camel = TableInfo.columnName(field);
            return camel.contains("_") ? camel + " AS " + field.getName() : camel;
        }

        public static String columnName(Field field) {
            return StrUtil.camel2Underscore(field.getName());
        }

        public static String bindParameter(Field field) {
            String value = "#{" + field.getName() + "}";
            return field.isAnnotationPresent(JSONColumn.class) ? value + "::JSONB" : value;
        }

        public static String assignParameter(Field field) {
            return TableInfo.columnName(field) + " = " + TableInfo.bindParameter(field);
        }

        public String getPrimaryKeyWhere() {
            String pk = this.primaryKeyColumn;
            return pk + " = #{" + pk + "}";
        }
    }

    public static abstract class BaseSqlProviderSupport {
        private static final Map<Class<?>, TableInfo> TABLE_CACHE = new ConcurrentHashMap(8);

        protected BaseSqlProviderSupport() {
        }

        protected TableInfo tableInfo(ProviderContext context) {
            return TABLE_CACHE.computeIfAbsent(context.getMapperType(), TableInfo::of);
        }
    }

    public static class SelectByPrimaryKeyInSqlProvider
    extends BaseSqlProviderSupport {
        public String sql(Map<String, Object> params, ProviderContext context) {
            List ids = (List)params.get("ids");
            TableInfo table = this.tableInfo(context);
            return ((SQL)((SQL)((SQL)new SQL().SELECT(table.selectColumns)).FROM(table.tableName)).WHERE(table.primaryKeyColumn + " IN (" + String.join((CharSequence)",", (CharSequence[])ids.stream().map(String::valueOf).toArray(String[]::new)) + ")")).toString();
        }
    }

    public static class SelectOneSqlProvider
    extends BaseSqlProviderSupport {
        public String sql(ProviderContext context) {
            TableInfo table = this.tableInfo(context);
            return ((SQL)((SQL)((SQL)new SQL().SELECT(table.selectColumns)).FROM(table.tableName)).WHERE(table.getPrimaryKeyWhere())).toString();
        }
    }

    public static class InsertWithoutPrimaryKeySqlProvider
    extends BaseSqlProviderSupport {
        public String sql(ProviderContext context) {
            TableInfo table = this.tableInfo(context);
            return ((SQL)((SQL)((SQL)new SQL().INSERT_INTO(table.tableName)).INTO_COLUMNS(table.columnsWithoutPrimaryKey)).INTO_VALUES((String[])Stream.of(table.fieldsWithoutPrimaryKey).map(TableInfo::bindParameter).toArray(String[]::new))).toString();
        }
    }

    public static class InsertSqlProvider
    extends BaseSqlProviderSupport {
        public String sql(ProviderContext context) {
            TableInfo table = this.tableInfo(context);
            return ((SQL)((SQL)((SQL)new SQL().INSERT_INTO(table.tableName)).INTO_COLUMNS(table.columns)).INTO_VALUES((String[])Stream.of(table.fields).map(TableInfo::bindParameter).toArray(String[]::new))).toString();
        }
    }
}

