/*
 * Decompiled with CFR 0.152.
 */
package cn.yunlingfly.swaggerspringbootstarter;

import cn.yunlingfly.swaggerspringbootstarter.infra.condition.SwaggerCondition;
import cn.yunlingfly.swaggerspringbootstarter.infra.config.SwaggerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@Conditional(value={SwaggerCondition.class})
@ConditionalOnProperty(prefix="swagger", value={"true"}, matchIfMissing=true)
public class SwaggerServiceAutoConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    private SwaggerProperties swaggerProperties;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).contact(new Contact(this.swaggerProperties.getContact().getName(), this.swaggerProperties.getContact().getUrl(), this.swaggerProperties.getContact().getEmail())).version(this.swaggerProperties.getVersion()).description(this.swaggerProperties.getDescription()).build();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.swaggerProperties.getBasePath()}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        super.addResourceHandlers(registry);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "OPTIONS", "DELETE", "PATCH"}).allowCredentials(true).maxAge(3600L);
    }
}

