/*
 * Decompiled with CFR 0.152.
 */
package cn.yuncloud.gmsm.sm2;

import cn.yuncloud.gmsm.exception.SmCryptoException;
import cn.yuncloud.gmsm.sm2.SM2EngineExtend;
import cn.yuncloud.gmsm.sm2.SM2KeyPair;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Locale;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2 {
    public static final String CRYPTO_NAME_SM2 = "sm2p256v1";

    public static SM2KeyPair generateSm2Keys(boolean compressed) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(domainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGenerator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        ECPoint ecPoint = publicKeyParameters.getQ();
        String publicKey = Hex.toHexString((byte[])ecPoint.getEncoded(compressed)).toUpperCase(Locale.ROOT);
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        BigInteger intPrivateKey = privateKeyParameters.getD();
        String privateKey = intPrivateKey.toString(16).toUpperCase(Locale.ROOT);
        return new SM2KeyPair(publicKey, privateKey);
    }

    public static String encrypt(String data, String pubKey) {
        return SM2.encrypt(data, pubKey, SM2EngineExtend.CIPHER_MODE_NORM);
    }

    public static String encrypt(String data, String pubKey, int cipherMode) {
        if (data == null) {
            return null;
        }
        if (pubKey.length() == 128) {
            pubKey = "04" + pubKey;
        }
        try {
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(true, cipherMode, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
            byte[] in = data.getBytes(StandardCharsets.UTF_8);
            byte[] arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherData, String priKey) {
        return SM2.decrypt(cipherData, priKey, SM2EngineExtend.CIPHER_MODE_NORM);
    }

    public static String decrypt(String cipherData, String priKey, int cipherMode) {
        try {
            if (cipherData == null) {
                return null;
            }
            if (!cipherData.startsWith("04")) {
                cipherData = "04" + cipherData;
            }
            byte[] cipherDataByte = Hex.decode((String)cipherData);
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            BigInteger privateKeyD = new BigInteger(priKey, 16);
            ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
            SM2EngineExtend sm2Engine = new SM2EngineExtend();
            sm2Engine.init(false, cipherMode, (CipherParameters)privateKeyParameters);
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            return new String(arrayOfBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String sign(String plainText, String priKey) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            BigInteger bigInteger = new BigInteger(priKey, 16);
            BCECPrivateKey bcecPrivateKey = (BCECPrivateKey)keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, ecParameterSpec));
            signature.initSign((PrivateKey)bcecPrivateKey);
            signature.update(plainText.getBytes());
            return Hex.toHexString((byte[])signature.sign()).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static boolean verify(String plainText, String pubKey, String signatureValue) {
        if (pubKey.length() == 128) {
            pubKey = "04" + pubKey;
        }
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)CRYPTO_NAME_SM2);
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN(), sm2ECParameters.getH());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
            Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)provider);
            ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKey));
            BCECPublicKey bcecPublicKey = (BCECPublicKey)keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, ecParameterSpec));
            signature.initVerify((PublicKey)bcecPublicKey);
            signature.update(plainText.getBytes());
            return signature.verify(Hex.decode((String)signatureValue));
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static boolean certVerify(String plaintext, String certStr, String signValueStr) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            byte[] signValue = Hex.decode((String)signValueStr);
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Hex.decode((String)certStr)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), (Provider)provider);
            signature.initVerify(certificate);
            signature.update(plaintext.getBytes());
            return signature.verify(signValue);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }
}

