/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.redislock;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    @Autowired
    private StringRedisTemplate template;
    @Autowired
    private DefaultRedisScript<Long> redisScript;
    private static final Long RELEASE_SUCCESS = 1L;
    private long timeout = 5000L;

    public boolean lock(String key, String value) {
        Boolean absent = this.template.opsForValue().setIfAbsent((Object)key, (Object)value, this.timeout, TimeUnit.MILLISECONDS);
        if (absent == null) {
            return false;
        }
        return absent;
    }

    public boolean unlock(String key, String value) {
        Long result = (Long)this.template.execute(this.redisScript, Arrays.asList(key, value), new Object[0]);
        return RELEASE_SUCCESS.equals(result);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Bean
    public DefaultRedisScript<Long> defaultRedisScript() {
        DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
        defaultRedisScript.setResultType(Long.class);
        defaultRedisScript.setScriptText("if redis.call('get', KEYS[1]) == KEYS[2] then return redis.call('del', KEYS[1]) else return 0 end");
        return defaultRedisScript;
    }
}

