/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.interceptor;

import cn.yueshutong.springbootstartercurrentlimiting.common.SpringContextUtil;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiterCloud;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiterSingle;
import cn.yueshutong.springbootstartercurrentlimiting.handler.CurrentInterceptorHandler;
import cn.yueshutong.springbootstartercurrentlimiting.interceptor.CurrentInterceptor;
import cn.yueshutong.springbootstartercurrentlimiting.properties.CurrentProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="current.limiting", name={"enabled"}, havingValue="true")
public class CurrentInterceptorConfig
implements WebMvcConfigurer {
    @Autowired
    private CurrentProperties properties;
    @Autowired(required=false)
    private CurrentInterceptorHandler handler;

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.properties.isCloudEnabled()) {
            registry.addInterceptor((HandlerInterceptor)new CurrentInterceptor(RateLimiterCloud.of(this.properties.getQps(), this.properties.getInitialDelay(), SpringContextUtil.getApplicationName()), this.properties.isFailFast(), this.handler)).addPathPatterns(new String[]{"/**"});
        } else {
            registry.addInterceptor((HandlerInterceptor)new CurrentInterceptor(RateLimiterSingle.of(this.properties.getQps(), this.properties.getInitialDelay()), this.properties.isFailFast(), this.handler)).addPathPatterns(new String[]{"/**"});
        }
    }
}

