/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.core;

import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimiterSingle
implements RateLimiter {
    private long QPS;
    private long period;
    private long initialDelay;
    private AtomicLong bucket = new AtomicLong(0L);

    private RateLimiterSingle(long QPS, long initialDelay) {
        this.QPS = QPS;
        this.initialDelay = initialDelay * 1000L;
        this.period = QPS > 0L ? 1000000L / QPS : Integer.MAX_VALUE;
        this.scheduled();
    }

    public static RateLimiter of(long QPS, long initialDelay) {
        return new RateLimiterSingle(QPS, initialDelay);
    }

    @Override
    public boolean tryAcquire() {
        long l = this.bucket.longValue();
        while (l <= 0L || !this.bucket.compareAndSet(l, l - 1L)) {
            l = this.bucket.longValue();
        }
        return true;
    }

    @Override
    public boolean tryAcquireFailed() {
        long l = this.bucket.longValue();
        while (l > 0L) {
            if (this.bucket.compareAndSet(l, l - 1L)) {
                return true;
            }
            l = this.bucket.longValue();
        }
        return false;
    }

    private void scheduled() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleAtFixedRate(() -> {
            if (this.QPS > this.bucket.longValue()) {
                this.bucket.incrementAndGet();
            }
        }, this.initialDelay, this.period, TimeUnit.MICROSECONDS);
    }
}

