/*
 * Decompiled with CFR 0.152.
 */
package cn.yueshutong.springbootstartercurrentlimiting.core;

import cn.yueshutong.springbootstartercurrentlimiting.common.RedisLockUtil;
import cn.yueshutong.springbootstartercurrentlimiting.common.SpringContextUtil;
import cn.yueshutong.springbootstartercurrentlimiting.core.RateLimiter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RateLimiterCloud
implements RateLimiter {
    private long QPS;
    private long period;
    private long initialDelay;
    private final int LOCK_GET_EXPIRES = 5000;
    private final int LOCK_PUT_EXPIRES = 10000;
    private String LOCK_GET;
    private String LOCK_PUT;
    private String BUCKET;
    private String LOCK_PUT_DATA;
    private final String AppCode = SpringContextUtil.getApplicationName() + SpringContextUtil.getPort() + this.hashCode();
    private StringRedisTemplate template = (StringRedisTemplate)SpringContextUtil.getBean(StringRedisTemplate.class);

    private RateLimiterCloud(long QPS, long initialDelay, String bucket) {
        this.QPS = QPS;
        this.initialDelay = initialDelay * 1000L;
        this.period = QPS > 0L ? 1000000L / QPS : Integer.MAX_VALUE;
        this.LOCK_GET = bucket + "$GET";
        this.LOCK_PUT = bucket + "$PUT";
        this.BUCKET = bucket;
        this.LOCK_PUT_DATA = this.LOCK_PUT + "$DATA";
        this.initBucket();
        this.scheduled();
    }

    public static RateLimiter of(long QPS, long initialDelay, String bucket) {
        return new RateLimiterCloud(QPS, initialDelay, bucket);
    }

    @Override
    public boolean tryAcquire() {
        try {
            RedisLockUtil.tryLock(this.template, this.LOCK_GET, this.LOCK_GET, 5000, TimeUnit.MILLISECONDS);
            Long s = Long.valueOf((String)this.template.opsForValue().get((Object)this.BUCKET));
            while (s <= 0L) {
                s = Long.valueOf((String)this.template.opsForValue().get((Object)this.BUCKET));
            }
            this.template.opsForValue().decrement((Object)this.BUCKET);
            boolean bl = true;
            return bl;
        }
        finally {
            RedisLockUtil.releaseLock(this.template, this.LOCK_GET);
        }
    }

    @Override
    public boolean tryAcquireFailed() {
        try {
            RedisLockUtil.tryLock(this.template, this.LOCK_GET, this.LOCK_GET, 5000, TimeUnit.MILLISECONDS);
            Long s = Long.valueOf((String)this.template.opsForValue().get((Object)this.BUCKET));
            if (s > 0L) {
                this.template.opsForValue().decrement((Object)this.BUCKET);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RedisLockUtil.releaseLock(this.template, this.LOCK_GET);
        }
    }

    private void scheduled() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (RedisLockUtil.tryLockFailed(RateLimiterCloud.this.template, RateLimiterCloud.this.LOCK_PUT, RateLimiterCloud.this.AppCode) || RateLimiterCloud.this.AppCode.equals(RateLimiterCloud.this.template.opsForValue().get((Object)RateLimiterCloud.this.LOCK_PUT))) {
                    Long s = Long.valueOf((String)RateLimiterCloud.this.template.opsForValue().get((Object)RateLimiterCloud.this.BUCKET));
                    if (RateLimiterCloud.this.QPS > s) {
                        RateLimiterCloud.this.template.opsForValue().increment((Object)RateLimiterCloud.this.BUCKET);
                    }
                    RateLimiterCloud.this.template.opsForValue().set((Object)RateLimiterCloud.this.LOCK_PUT_DATA, (Object)String.valueOf(System.currentTimeMillis()));
                } else {
                    Long s = Long.valueOf((String)RateLimiterCloud.this.template.opsForValue().get((Object)RateLimiterCloud.this.LOCK_PUT_DATA));
                    if (System.currentTimeMillis() - s > 10000L) {
                        RedisLockUtil.releaseLock(RateLimiterCloud.this.template, RateLimiterCloud.this.LOCK_PUT);
                    }
                }
            }
        }, this.initialDelay, this.period, TimeUnit.MICROSECONDS);
    }

    private void initBucket() {
        try {
            RedisLockUtil.tryLock(this.template, this.LOCK_GET, this.LOCK_GET, 5000, TimeUnit.MILLISECONDS);
            this.template.opsForValue().set((Object)this.BUCKET, (Object)String.valueOf(0));
        }
        finally {
            RedisLockUtil.releaseLock(this.template, this.LOCK_PUT);
        }
    }
}

